/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.rate;

import io.javaoperatorsdk.operator.api.config.AnnotationConfigurable;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimited;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.rate.RateState;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;

public class LinearRateLimiter
implements RateLimiter<RateState>,
AnnotationConfigurable<RateLimited> {
    public static final int NO_LIMIT_PERIOD = -1;
    public static final int DEFAULT_REFRESH_PERIOD_SECONDS = 10;
    public static final Duration DEFAULT_REFRESH_PERIOD = Duration.ofSeconds(10L);
    private Duration refreshPeriod;
    private int limitForPeriod;

    public static LinearRateLimiter deactivatedRateLimiter() {
        return new LinearRateLimiter();
    }

    public LinearRateLimiter() {
        this(DEFAULT_REFRESH_PERIOD, -1);
    }

    public LinearRateLimiter(Duration refreshPeriod, int limitForPeriod) {
        this.refreshPeriod = refreshPeriod;
        this.limitForPeriod = limitForPeriod;
    }

    @Override
    public Optional<Duration> isLimited(RateLimiter.RateLimitState rateLimitState) {
        if (!this.isActivated() || !(rateLimitState instanceof RateState)) {
            return Optional.empty();
        }
        RateState actualState = (RateState)rateLimitState;
        if (actualState.getCount() < this.limitForPeriod) {
            actualState.increaseCount();
            return Optional.empty();
        }
        if (actualState.getLastRefreshTime().isBefore(LocalDateTime.now().minus(this.refreshPeriod))) {
            actualState.reset();
            actualState.increaseCount();
            return Optional.empty();
        }
        return Optional.of(Duration.between(actualState.getLastRefreshTime(), LocalDateTime.now()));
    }

    @Override
    public RateState initState() {
        return RateState.initialState();
    }

    @Override
    public void initFrom(RateLimited configuration) {
        this.refreshPeriod = Duration.of(configuration.within(), configuration.unit().toChronoUnit());
        this.limitForPeriod = configuration.maxReconciliations();
    }

    public boolean isActivated() {
        return this.limitForPeriod > 0;
    }

    public int getLimitForPeriod() {
        return this.limitForPeriod;
    }

    public Duration getRefreshPeriod() {
        return this.refreshPeriod;
    }
}

