/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.health;

import io.javaoperatorsdk.operator.health.EventSourceHealthIndicator;
import io.javaoperatorsdk.operator.health.InformerWrappingEventSourceHealthIndicator;
import io.javaoperatorsdk.operator.health.Status;
import io.javaoperatorsdk.operator.processing.event.EventSourceManager;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import java.util.Map;
import java.util.stream.Collectors;

public class ControllerHealthInfo {
    private final EventSourceManager<?> eventSourceManager;

    public ControllerHealthInfo(EventSourceManager eventSourceManager) {
        this.eventSourceManager = eventSourceManager;
    }

    public Map<String, EventSourceHealthIndicator> eventSourceHealthIndicators() {
        return this.eventSourceManager.allEventSources().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, EventSourceHealthIndicator> unhealthyEventSources() {
        return this.eventSourceManager.allEventSources().entrySet().stream().filter(e -> ((EventSource)e.getValue()).getStatus() == Status.UNHEALTHY).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, InformerWrappingEventSourceHealthIndicator> informerEventSourceHealthIndicators() {
        return this.eventSourceManager.allEventSources().entrySet().stream().filter(e -> e.getValue() instanceof InformerWrappingEventSourceHealthIndicator).collect(Collectors.toMap(Map.Entry::getKey, e -> (InformerWrappingEventSourceHealthIndicator)e.getValue()));
    }

    public Map<String, InformerWrappingEventSourceHealthIndicator> unhealthyInformerEventSourceHealthIndicators() {
        return this.eventSourceManager.allEventSources().entrySet().stream().filter(e -> ((EventSource)e.getValue()).getStatus() == Status.UNHEALTHY).filter(e -> e.getValue() instanceof InformerWrappingEventSourceHealthIndicator).collect(Collectors.toMap(Map.Entry::getKey, e -> (InformerWrappingEventSourceHealthIndicator)e.getValue()));
    }
}

