/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.Ignore;
import io.javaoperatorsdk.operator.api.reconciler.dependent.EventSourceNotFoundException;
import io.javaoperatorsdk.operator.api.reconciler.dependent.EventSourceReferencer;
import io.javaoperatorsdk.operator.api.reconciler.dependent.RecentOperationCacheFiller;
import io.javaoperatorsdk.operator.processing.dependent.AbstractDependentResource;
import io.javaoperatorsdk.operator.processing.event.EventSourceRetriever;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.ResourceEventSource;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnDeleteFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import java.util.Optional;

@Ignore
public abstract class AbstractEventSourceHolderDependentResource<R, P extends HasMetadata, T extends ResourceEventSource<R, P>>
extends AbstractDependentResource<R, P>
implements EventSourceReferencer<P> {
    private T eventSource;
    private final Class<R> resourceType;
    private boolean isCacheFillerEventSource;
    protected OnAddFilter<R> onAddFilter;
    protected OnUpdateFilter<R> onUpdateFilter;
    protected OnDeleteFilter<R> onDeleteFilter;
    protected GenericFilter<R> genericFilter;
    protected String eventSourceNameToUse;

    protected AbstractEventSourceHolderDependentResource(Class<R> resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public synchronized Optional<T> eventSource(EventSourceContext<P> context) {
        if (this.eventSource == null && this.eventSourceNameToUse == null) {
            this.setEventSource(this.createEventSource(context));
            this.applyFilters();
        }
        return Optional.ofNullable(this.eventSource);
    }

    @Override
    public void resolveEventSource(EventSourceRetriever<P> eventSourceRetriever) {
        if (this.eventSourceNameToUse != null && this.eventSource == null) {
            ResourceEventSource<R, P> source = eventSourceRetriever.getResourceEventSourceFor(this.resourceType(), this.eventSourceNameToUse);
            if (source == null) {
                throw new EventSourceNotFoundException(this.eventSourceNameToUse);
            }
            this.setEventSource(source);
        }
    }

    public T initEventSource(EventSourceContext<P> context) {
        return (T)((ResourceEventSource)this.eventSource(context).orElseThrow());
    }

    @Override
    public void useEventSourceWithName(String name) {
        this.eventSourceNameToUse = name;
    }

    @Override
    public Class<R> resourceType() {
        return this.resourceType;
    }

    protected abstract T createEventSource(EventSourceContext<P> var1);

    protected void setEventSource(T eventSource) {
        this.isCacheFillerEventSource = eventSource instanceof RecentOperationCacheFiller;
        this.eventSource = eventSource;
    }

    protected void applyFilters() {
        this.eventSource.setOnAddFilter(this.onAddFilter);
        this.eventSource.setOnUpdateFilter(this.onUpdateFilter);
        this.eventSource.setOnDeleteFilter(this.onDeleteFilter);
        this.eventSource.setGenericFilter(this.genericFilter);
    }

    public Optional<T> eventSource() {
        return Optional.ofNullable(this.eventSource);
    }

    @Override
    protected void onCreated(P primary, R created, Context<P> context) {
        if (this.isCacheFillerEventSource) {
            this.recentOperationCacheFiller().handleRecentResourceCreate(ResourceID.fromResource(primary), created);
        }
    }

    @Override
    protected void onUpdated(P primary, R updated, R actual, Context<P> context) {
        if (this.isCacheFillerEventSource) {
            this.recentOperationCacheFiller().handleRecentResourceUpdate(ResourceID.fromResource(primary), updated, actual);
        }
    }

    private RecentOperationCacheFiller<R> recentOperationCacheFiller() {
        return (RecentOperationCacheFiller)this.eventSource;
    }

    public void setOnAddFilter(OnAddFilter<R> onAddFilter) {
        this.onAddFilter = onAddFilter;
    }

    public void setOnUpdateFilter(OnUpdateFilter<R> onUpdateFilter) {
        this.onUpdateFilter = onUpdateFilter;
    }

    public void setOnDeleteFilter(OnDeleteFilter<R> onDeleteFilter) {
        this.onDeleteFilter = onDeleteFilter;
    }
}

