/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public interface ResourceConfiguration<R extends HasMetadata> {
    default public String getResourceTypeName() {
        return ReconcilerUtils.getResourceTypeName(this.getResourceClass());
    }

    default public Optional<OnAddFilter<? super R>> onAddFilter() {
        return Optional.empty();
    }

    default public Optional<OnUpdateFilter<? super R>> onUpdateFilter() {
        return Optional.empty();
    }

    default public Optional<GenericFilter<? super R>> genericFilter() {
        return Optional.empty();
    }

    default public String getLabelSelector() {
        return null;
    }

    public static String ensureValidLabelSelector(String labelSelector) {
        return labelSelector;
    }

    default public Class<R> getResourceClass() {
        return Utils.getFirstTypeArgumentFromSuperClassOrInterface(this.getClass(), ResourceConfiguration.class);
    }

    default public Set<String> getNamespaces() {
        return Constants.DEFAULT_NAMESPACES_SET;
    }

    default public boolean watchAllNamespaces() {
        return ResourceConfiguration.allNamespacesWatched(this.getNamespaces());
    }

    public static boolean allNamespacesWatched(Set<String> namespaces) {
        ResourceConfiguration.failIfNotValid(namespaces);
        return Constants.DEFAULT_NAMESPACES_SET.equals(namespaces);
    }

    default public boolean watchCurrentNamespace() {
        return ResourceConfiguration.currentNamespaceWatched(this.getNamespaces());
    }

    public static boolean currentNamespaceWatched(Set<String> namespaces) {
        ResourceConfiguration.failIfNotValid(namespaces);
        return Constants.WATCH_CURRENT_NAMESPACE_SET.equals(namespaces);
    }

    public static void failIfNotValid(Set<String> namespaces) {
        if (namespaces != null && !namespaces.isEmpty()) {
            boolean present;
            boolean bl = present = namespaces.contains("JOSDK_WATCH_CURRENT") || namespaces.contains("JOSDK_ALL_NAMESPACES");
            if (!present || namespaces.size() == 1) {
                return;
            }
        }
        throw new IllegalArgumentException("Must specify namespaces. To watch all namespaces, use only 'JOSDK_ALL_NAMESPACES'. To watch only the namespace in which the operator is deployed, use only 'JOSDK_WATCH_CURRENT'");
    }

    public static Set<String> ensureValidNamespaces(Collection<String> namespaces) {
        if (namespaces != null && !namespaces.isEmpty()) {
            return Set.copyOf(namespaces);
        }
        return Constants.DEFAULT_NAMESPACES_SET;
    }

    default public Set<String> getEffectiveNamespaces(ConfigurationService configurationService) {
        Set<String> targetNamespaces = this.getNamespaces();
        if (this.watchCurrentNamespace()) {
            String namespace = configurationService.getKubernetesClient().getConfiguration().getNamespace();
            if (namespace == null) {
                throw new OperatorException("Couldn't retrieve the currently connected namespace. Make sure it's correctly set in your ~/.kube/config file, using, e.g. 'kubectl config set-context <your context> --namespace=<your namespace>'");
            }
            targetNamespaces = Collections.singleton(namespace);
        }
        return targetNamespaces;
    }

    default public Optional<ItemStore<R>> getItemStore() {
        return Optional.empty();
    }

    default public Optional<Long> getInformerListLimit() {
        return Optional.empty();
    }
}

