/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.core;

import io.quarkiverse.operatorsdk.annotations.CSVMetadata;
import io.quarkiverse.operatorsdk.annotations.SharedCSVMetadata;

@CSVMetadata(name="${olm.bundle.name}", displayName="Debezium Operator", icon={@CSVMetadata.Icon(fileName="debezium-icon.svg")}, provider=@CSVMetadata.Provider(name="Debezium Authors", url="https://debezium.io/"), maintainers={@CSVMetadata.Maintainer(name="Debezium Authors", email="debezium@googlegroups.com")}, keywords={"Debezium", "CDC", "Data", "Streaming"}, links={@CSVMetadata.Link(url="https://debezium.io/", name="Debezium"), @CSVMetadata.Link(url="https://debezium.io/documentation/reference/stable/", name="Documentation"), @CSVMetadata.Link(url="https://debezium.zulipchat.com", name="Debezium Zulip Chat")}, installModes={@CSVMetadata.InstallMode(type="OwnNamespace"), @CSVMetadata.InstallMode(type="SingleNamespace"), @CSVMetadata.InstallMode(type="AllNamespaces"), @CSVMetadata.InstallMode(type="MultiNamespace")}, annotations=@CSVMetadata.Annotations(repository="${olm.bundle.repository}", capabilities="Basic Install", categories="Big Data, Database, Integration & Delivery, Streaming & Messaging", containerImage="${olm.bundle.containerImage}", others={@CSVMetadata.Annotations.Annotation(name="createdAt", value="${olm.bundle.createdAt}"), @CSVMetadata.Annotations.Annotation(name="support", value="Debezium Authors"), @CSVMetadata.Annotations.Annotation(name="description", value="An Operator for installing and managing Debezium")}, almExamples="[\n    {\n      \"apiVersion\": \"debezium.io/v1alpha1\",\n      \"kind\": \"DebeziumServer\",\n      \"metadata\": {\n        \"name\": \"debezium-test\"\n      },\n      \"spec\": {\n        \"quarkus\": {\n          \"config\": {\n            \"log.console.json\": false\n          }\n        },\n        \"sink\": {\n          \"type\": \"kafka\",\n          \"config\": {\n            \"producer.bootstrap.servers\": \"dbz-kafka-kafka-bootstrap.debezium:9092\",\n            \"producer.key.serializer\": \"org.apache.kafka.common.serialization.StringSerializer\",\n            \"producer.value.serializer\": \"org.apache.kafka.common.serialization.StringSerializer\"\n          }\n        },\n        \"source\": {\n          \"class\": \"io.debezium.connector.mongodb.MongoDbConnector\",\n          \"config\": {\n            \"topic.prefix\": \"dbserver1\",\n            \"offset.storage.file.filename\": \"/debezium/data/offsets.dat\",\n            \"database.history\": \"io.debezium.relational.history.FileDatabaseHistory\",\n            \"mongodb.connection.string\": \"mongodb://debezium:dbz@mongo.debezium:27017/?replicaSet=rs0\"\n          }\n        }\n      }\n    }\n]\n"), description="Debezium is an open source distributed platform for change data capture. Start it up, point it at your databases, and your apps can start responding to all of the inserts, updates, and deletes that other apps commit to your databases")
public class DebeziumCsvMetadata
implements SharedCSVMetadata {
}

