/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;

@API(status=API.Status.STABLE, since="1.0")
public class MethodSelector
implements DiscoverySelector {
    private final ClassLoader classLoader;
    private final String className;
    private final String methodName;
    private final String parameterTypeNames;
    private volatile Class<?> javaClass;
    private volatile Method javaMethod;
    private volatile Class<?>[] parameterTypes;

    MethodSelector(ClassLoader classLoader, String className, String methodName, String parameterTypeNames) {
        this.classLoader = classLoader;
        this.className = className;
        this.methodName = methodName;
        this.parameterTypeNames = parameterTypeNames;
    }

    MethodSelector(Class<?> javaClass, String methodName, String parameterTypeNames) {
        this.classLoader = javaClass.getClassLoader();
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.methodName = methodName;
        this.parameterTypeNames = parameterTypeNames;
    }

    MethodSelector(ClassLoader classLoader, String className, String methodName, Class<?> ... parameterTypes) {
        this.classLoader = classLoader;
        this.className = className;
        this.methodName = methodName;
        this.parameterTypes = (Class[])parameterTypes.clone();
        this.parameterTypeNames = ClassUtils.nullSafeToString(Class::getTypeName, (Class[])this.parameterTypes);
    }

    MethodSelector(Class<?> javaClass, String methodName, Class<?> ... parameterTypes) {
        this.classLoader = javaClass.getClassLoader();
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.methodName = methodName;
        this.parameterTypes = (Class[])parameterTypes.clone();
        this.parameterTypeNames = ClassUtils.nullSafeToString(Class::getTypeName, (Class[])this.parameterTypes);
    }

    MethodSelector(Class<?> javaClass, Method method) {
        this.classLoader = javaClass.getClassLoader();
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.javaMethod = method;
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.parameterTypeNames = ClassUtils.nullSafeToString(Class::getTypeName, (Class[])this.parameterTypes);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.10")
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.10")
    public String getMethodParameterTypes() {
        return this.getParameterTypeNames();
    }

    @API(status=API.Status.STABLE, since="1.10")
    public String getParameterTypeNames() {
        return this.parameterTypeNames;
    }

    public Class<?> getJavaClass() {
        this.lazyLoadJavaClass();
        return this.javaClass;
    }

    public Method getJavaMethod() {
        this.lazyLoadJavaMethod();
        return this.javaMethod;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.10")
    public Class<?>[] getParameterTypes() {
        this.lazyLoadParameterTypes();
        return (Class[])this.parameterTypes.clone();
    }

    private void lazyLoadJavaClass() {
        if (this.javaClass == null) {
            Try tryToLoadClass = this.classLoader == null ? ReflectionUtils.tryToLoadClass((String)this.className) : ReflectionUtils.tryToLoadClass((String)this.className, (ClassLoader)this.classLoader);
            this.javaClass = (Class)tryToLoadClass.getOrThrow(cause -> new PreconditionViolationException("Could not load class with name: " + this.className, (Throwable)cause));
        }
    }

    private void lazyLoadJavaMethod() {
        if (this.javaMethod == null) {
            this.lazyLoadJavaClass();
            this.lazyLoadParameterTypes();
            this.javaMethod = this.parameterTypes.length > 0 ? (Method)ReflectionUtils.findMethod(this.javaClass, (String)this.methodName, (Class[])this.parameterTypes).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] and parameter types [%s] in class [%s].", this.methodName, this.parameterTypeNames, this.javaClass.getName()))) : (Method)ReflectionUtils.findMethod(this.javaClass, (String)this.methodName, (Class[])new Class[0]).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] in class [%s].", this.methodName, this.javaClass.getName())));
        }
    }

    private void lazyLoadParameterTypes() {
        if (this.parameterTypes == null) {
            this.lazyLoadJavaClass();
            this.parameterTypes = ReflectionUtils.resolveParameterTypes(this.javaClass, (String)this.methodName, (String)this.parameterTypeNames);
        }
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSelector that = (MethodSelector)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.parameterTypeNames, that.parameterTypeNames);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.parameterTypeNames);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("className", (Object)this.getClassName()).append("methodName", (Object)this.getMethodName()).append("parameterTypes", (Object)this.getParameterTypeNames()).append("classLoader", (Object)this.getClassLoader()).toString();
    }
}

