/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.dependent.RecentOperationCacheFiller;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.AbstractResourceEventSource;
import io.javaoperatorsdk.operator.processing.event.source.CacheKeyMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalResourceCachingEventSource<R, P extends HasMetadata>
extends AbstractResourceEventSource<R, P>
implements RecentOperationCacheFiller<R> {
    private static final Logger log = LoggerFactory.getLogger(ExternalResourceCachingEventSource.class);
    protected final CacheKeyMapper<R> cacheKeyMapper;
    protected Map<ResourceID, Map<String, R>> cache = new ConcurrentHashMap<ResourceID, Map<String, R>>();

    protected ExternalResourceCachingEventSource(Class<R> resourceClass, CacheKeyMapper<R> cacheKeyMapper) {
        super(resourceClass);
        this.cacheKeyMapper = cacheKeyMapper;
    }

    protected synchronized void handleDelete(ResourceID primaryID) {
        Map<String, R> res = this.cache.remove(primaryID);
        if (res != null && this.deleteAcceptedByFilter(res.values())) {
            this.getEventHandler().handleEvent(new Event(primaryID));
        }
    }

    protected synchronized void handleDeletes(ResourceID primaryID, Set<R> resource) {
        this.handleDelete(primaryID, resource.stream().map(this.cacheKeyMapper::keyFor).collect(Collectors.toSet()));
    }

    protected synchronized void handleDelete(ResourceID primaryID, R resource) {
        this.handleDelete(primaryID, Set.of(this.cacheKeyMapper.keyFor(resource)));
    }

    protected synchronized void handleDelete(ResourceID primaryID, Set<String> resourceIDs) {
        List removedResources;
        if (!this.isRunning()) {
            return;
        }
        Map cachedValues = this.cache.get(primaryID);
        List list = removedResources = cachedValues == null ? Collections.emptyList() : resourceIDs.stream().flatMap(id -> Stream.ofNullable(cachedValues.remove(id))).collect(Collectors.toList());
        if (cachedValues != null && cachedValues.isEmpty()) {
            this.cache.remove(primaryID);
        }
        if (!removedResources.isEmpty() && this.deleteAcceptedByFilter(removedResources)) {
            this.getEventHandler().handleEvent(new Event(primaryID));
        }
    }

    protected synchronized void handleResources(ResourceID primaryID, R actualResource) {
        this.handleResources(primaryID, Set.of(actualResource), true);
    }

    protected synchronized void handleResources(ResourceID primaryID, Set<R> newResources) {
        this.handleResources(primaryID, newResources, true);
    }

    protected synchronized void handleResources(Map<ResourceID, Set<R>> allNewResources) {
        List<ResourceID> toDelete = this.cache.keySet().stream().filter(k -> !allNewResources.containsKey(k)).collect(Collectors.toList());
        toDelete.forEach(this::handleDelete);
        allNewResources.forEach(this::handleResources);
    }

    protected synchronized void handleResources(ResourceID primaryID, Set<R> newResources, boolean propagateEvent) {
        log.debug("Handling resources update for: {} numberOfResources: {} ", (Object)primaryID, (Object)newResources.size());
        if (!this.isRunning()) {
            return;
        }
        Map<String, Object> cachedResources = this.cache.get(primaryID);
        if (cachedResources == null) {
            cachedResources = Collections.emptyMap();
        }
        Map<String, Object> newResourcesMap = newResources.stream().collect(Collectors.toMap(this.cacheKeyMapper::keyFor, r -> r));
        this.cache.put(primaryID, newResourcesMap);
        if (propagateEvent && !newResourcesMap.equals(cachedResources) && this.acceptedByFiler(cachedResources, newResourcesMap)) {
            this.getEventHandler().handleEvent(new Event(primaryID));
        }
    }

    private boolean acceptedByFiler(Map<String, R> cachedResourceMap, Map<String, R> newResourcesMap) {
        boolean anyUpdated;
        boolean anyDeleteAccepted;
        boolean anyAddAccepted;
        HashMap<String, R> addedResources = new HashMap<String, R>(newResourcesMap);
        addedResources.keySet().removeAll(cachedResourceMap.keySet());
        if (this.onAddFilter != null || this.genericFilter != null ? (anyAddAccepted = addedResources.values().stream().anyMatch(r -> this.acceptedByGenericFiler(r) && this.onAddFilter.accept(r))) : !addedResources.isEmpty()) {
            return true;
        }
        HashMap<String, R> deletedResource = new HashMap<String, R>(cachedResourceMap);
        deletedResource.keySet().removeAll(newResourcesMap.keySet());
        if (this.onDeleteFilter != null || this.genericFilter != null ? (anyDeleteAccepted = deletedResource.values().stream().anyMatch(r -> this.acceptedByGenericFiler(r) && this.onDeleteFilter.accept(r, false))) : !deletedResource.isEmpty()) {
            return true;
        }
        Map<String, Object> possibleUpdatedResources = new HashMap<String, R>(cachedResourceMap);
        possibleUpdatedResources.keySet().retainAll(newResourcesMap.keySet());
        possibleUpdatedResources = possibleUpdatedResources.entrySet().stream().filter(entry -> !newResourcesMap.get(entry.getKey()).equals(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return this.onUpdateFilter != null || this.genericFilter != null ? (anyUpdated = possibleUpdatedResources.entrySet().stream().anyMatch(entry -> {
            Object newResource = newResourcesMap.get(entry.getKey());
            return this.acceptedByGenericFiler(newResource) && this.onUpdateFilter.accept(newResource, entry.getValue());
        })) : !possibleUpdatedResources.isEmpty();
    }

    private boolean acceptedByGenericFiler(R resource) {
        return this.genericFilter == null || this.genericFilter.accept(resource);
    }

    @Override
    public synchronized void handleRecentResourceCreate(ResourceID primaryID, R resource) {
        Map<String, R> actualValues = this.cache.get(primaryID);
        String resourceId = this.cacheKeyMapper.keyFor(resource);
        if (actualValues == null) {
            actualValues = new HashMap<String, R>();
            this.cache.put(primaryID, actualValues);
            actualValues.put(resourceId, resource);
        } else {
            actualValues.computeIfAbsent(resourceId, r -> resource);
        }
    }

    @Override
    public synchronized void handleRecentResourceUpdate(ResourceID primaryID, R resource, R previousVersionOfResource) {
        String resourceId;
        R actualResource;
        Map<String, R> actualValues = this.cache.get(primaryID);
        if (actualValues != null && (actualResource = actualValues.get(resourceId = this.cacheKeyMapper.keyFor(resource))).equals(previousVersionOfResource)) {
            actualValues.put(resourceId, resource);
        }
    }

    @Override
    public Set<R> getSecondaryResources(P primary) {
        return this.getSecondaryResources(ResourceID.fromResource(primary));
    }

    @Override
    public Set<R> getSecondaryResources(ResourceID primaryID) {
        Map<String, R> cachedValues = this.cache.get(primaryID);
        if (cachedValues == null) {
            return Collections.emptySet();
        }
        return new HashSet<R>(this.cache.get(primaryID).values());
    }

    @Override
    public Optional<R> getSecondaryResource(ResourceID primaryID) {
        Set<R> resources = this.getSecondaryResources(primaryID);
        if (resources.isEmpty()) {
            return Optional.empty();
        }
        if (resources.size() == 1) {
            return Optional.of(resources.iterator().next());
        }
        throw new IllegalStateException("More than 1 secondary resource related to primary");
    }

    public Map<ResourceID, Map<String, R>> getCache() {
        return Collections.unmodifiableMap(this.cache);
    }

    protected boolean deleteAcceptedByFilter(Collection<R> res) {
        if (this.onDeleteFilter == null) {
            return true;
        }
        return res.stream().anyMatch(r -> this.onDeleteFilter.accept(r, false));
    }
}

