/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ExecutorServiceManager;
import io.javaoperatorsdk.operator.api.config.Version;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class AbstractConfigurationService
implements ConfigurationService {
    private final Map<String, ControllerConfiguration> configurations = new ConcurrentHashMap<String, ControllerConfiguration>();
    private final Version version;
    private KubernetesClient client;
    private Cloner cloner;
    private ExecutorServiceManager executorServiceManager;

    public AbstractConfigurationService(Version version) {
        this(version, null);
    }

    public AbstractConfigurationService(Version version, Cloner cloner) {
        this(version, cloner, null, null);
    }

    public AbstractConfigurationService(Version version, Cloner cloner, ExecutorServiceManager executorServiceManager, KubernetesClient client) {
        this.version = version;
        this.init(cloner, executorServiceManager, client);
    }

    protected void init(Cloner cloner, ExecutorServiceManager executorServiceManager, KubernetesClient client) {
        this.client = client;
        this.cloner = cloner != null ? cloner : ConfigurationService.super.getResourceCloner();
        this.executorServiceManager = executorServiceManager;
    }

    protected <R extends HasMetadata> void register(ControllerConfiguration<R> config) {
        this.put(config, true);
    }

    protected <R extends HasMetadata> void replace(ControllerConfiguration<R> config) {
        this.put(config, false);
    }

    private <R extends HasMetadata> void put(ControllerConfiguration<R> config, boolean failIfExisting) {
        ControllerConfiguration existing;
        String name = config.getName();
        if (failIfExisting && (existing = this.configurations.get(name)) != null) {
            this.throwExceptionOnNameCollision(config.getAssociatedReconcilerClassName(), existing);
        }
        this.configurations.put(name, config);
    }

    protected <R extends HasMetadata> void throwExceptionOnNameCollision(String newReconcilerClassName, ControllerConfiguration<R> existing) {
        throw new IllegalArgumentException("Reconciler name '" + existing.getName() + "' is used by both " + existing.getAssociatedReconcilerClassName() + " and " + newReconcilerClassName);
    }

    @Override
    public <R extends HasMetadata> ControllerConfiguration<R> getConfigurationFor(Reconciler<R> reconciler) {
        String key = this.keyFor(reconciler);
        ControllerConfiguration configuration = this.configurations.get(key);
        if (configuration == null) {
            this.logMissingReconcilerWarning(key, this.getReconcilersNameMessage());
        }
        return configuration;
    }

    protected void logMissingReconcilerWarning(String reconcilerKey, String reconcilersNameMessage) {
        log.warn("Cannot find reconciler named '{}'. {}", (Object)reconcilerKey, (Object)reconcilersNameMessage);
    }

    private String getReconcilersNameMessage() {
        return "Known reconcilers: " + this.getKnownReconcilerNames().stream().reduce((s, s2) -> s + ", " + s2).orElse("None") + ".";
    }

    protected <R extends HasMetadata> String keyFor(Reconciler<R> reconciler) {
        return ReconcilerUtils.getNameFor(reconciler);
    }

    protected ControllerConfiguration getFor(String reconcilerName) {
        return this.configurations.get(reconcilerName);
    }

    protected Stream<ControllerConfiguration> controllerConfigurations() {
        return this.configurations.values().stream();
    }

    @Override
    public Set<String> getKnownReconcilerNames() {
        return this.configurations.keySet();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Cloner getResourceCloner() {
        return this.cloner;
    }

    @Override
    public KubernetesClient getKubernetesClient() {
        if (this.client == null) {
            this.client = ConfigurationService.super.getKubernetesClient();
        }
        return this.client;
    }

    @Override
    public ExecutorServiceManager getExecutorServiceManager() {
        if (this.executorServiceManager == null) {
            this.executorServiceManager = ConfigurationService.super.getExecutorServiceManager();
        }
        return this.executorServiceManager;
    }
}

