/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.doc;

import io.vertx.codegen.Helper;
import io.vertx.codegen.type.TypeInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;

public class Tag {
    final String name;
    final String value;

    public Tag(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Tag) {
            Tag that = (Tag)o;
            return this.name.equals(that.name) && this.value.equals(that.value);
        }
        return false;
    }

    public String toString() {
        return "@" + this.name + " " + this.value;
    }

    public static class Link
    extends Tag {
        final Element targetElement;
        final TypeInfo targetType;
        final String label;

        public Link(String rawValue, Element targetElement, TypeInfo type, String label) {
            super("link", rawValue);
            this.targetElement = targetElement;
            this.targetType = type;
            this.label = label;
        }

        public Element getTargetElement() {
            return this.targetElement;
        }

        public TypeInfo getTargetType() {
            return this.targetType;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static class Param
    extends Tag {
        private static final Pattern PARAM_PATTERN = Pattern.compile("^\\s*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)(?:\\s((?:\\n|.)*))?");
        final String paramName;
        final String paramDescription;

        public Param(Tag other) {
            this(other.name, other.value);
        }

        public Param(String name, String value) {
            super(name, value);
            Matcher matcher = PARAM_PATTERN.matcher(value);
            if (matcher.matches()) {
                this.paramName = matcher.group(1);
                String desc = matcher.group(2);
                if (desc != null) {
                    desc = Helper.normalizeWhitespaces(desc);
                }
                this.paramDescription = desc != null && !desc.trim().isEmpty() ? desc.trim() : null;
            } else {
                this.paramName = null;
                this.paramDescription = null;
            }
        }

        public String getParamName() {
            return this.paramName;
        }

        public String getParamDescription() {
            return this.paramDescription;
        }
    }
}

