/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openshift.api.model.monitoring.v1.PrometheusTracingConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PrometheusTracingConfigFluent<A extends PrometheusTracingConfigFluent<A>>
extends BaseFluent<A> {
    private String clientType;
    private String compression;
    private String endpoint;
    private Map<String, String> headers;
    private Boolean insecure;
    private Quantity samplingFraction;
    private String timeout;
    private TLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public PrometheusTracingConfigFluent() {
    }

    public PrometheusTracingConfigFluent(PrometheusTracingConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PrometheusTracingConfig instance) {
        PrometheusTracingConfig prometheusTracingConfig = instance = instance != null ? instance : new PrometheusTracingConfig();
        if (instance != null) {
            this.withClientType(instance.getClientType());
            this.withCompression(instance.getCompression());
            this.withEndpoint(instance.getEndpoint());
            this.withHeaders(instance.getHeaders());
            this.withInsecure(instance.getInsecure());
            this.withSamplingFraction(instance.getSamplingFraction());
            this.withTimeout(instance.getTimeout());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getClientType() {
        return this.clientType;
    }

    public A withClientType(String clientType) {
        this.clientType = clientType;
        return (A)((Object)this);
    }

    public boolean hasClientType() {
        return this.clientType != null;
    }

    public String getCompression() {
        return this.compression;
    }

    public A withCompression(String compression) {
        this.compression = compression;
        return (A)((Object)this);
    }

    public boolean hasCompression() {
        return this.compression != null;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public A withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return (A)((Object)this);
    }

    public boolean hasEndpoint() {
        return this.endpoint != null;
    }

    public A addToHeaders(String key, String value) {
        if (this.headers == null && key != null && value != null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToHeaders(Map<String, String> map) {
        if (this.headers == null && map != null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.headers.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(String key) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (key != null && this.headers != null) {
            this.headers.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(Map<String, String> map) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.headers == null) continue;
                this.headers.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public <K, V> A withHeaders(Map<String, String> headers) {
        this.headers = headers == null ? null : new LinkedHashMap<String, String>(headers);
        return (A)((Object)this);
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public Boolean getInsecure() {
        return this.insecure;
    }

    public A withInsecure(Boolean insecure) {
        this.insecure = insecure;
        return (A)((Object)this);
    }

    public boolean hasInsecure() {
        return this.insecure != null;
    }

    public Quantity getSamplingFraction() {
        return this.samplingFraction;
    }

    public A withSamplingFraction(Quantity samplingFraction) {
        this.samplingFraction = samplingFraction;
        return (A)((Object)this);
    }

    public boolean hasSamplingFraction() {
        return this.samplingFraction != null;
    }

    public A withNewSamplingFraction(String amount, String format) {
        return this.withSamplingFraction(new Quantity(amount, format));
    }

    public A withNewSamplingFraction(String amount) {
        return this.withSamplingFraction(new Quantity(amount));
    }

    public String getTimeout() {
        return this.timeout;
    }

    public A withTimeout(String timeout) {
        this.timeout = timeout;
        return (A)((Object)this);
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public TLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(TLSConfig tlsConfig) {
        this._visitables.remove((Object)"tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new TLSConfigBuilder(tlsConfig);
            this._visitables.get((Object)"tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get((Object)"tlsConfig").remove((Object)this.tlsConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrometheusTracingConfigFluent that = (PrometheusTracingConfigFluent)((Object)o);
        if (!Objects.equals(this.clientType, that.clientType)) {
            return false;
        }
        if (!Objects.equals(this.compression, that.compression)) {
            return false;
        }
        if (!Objects.equals(this.endpoint, that.endpoint)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.insecure, that.insecure)) {
            return false;
        }
        if (!Objects.equals(this.samplingFraction, that.samplingFraction)) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsConfig, (Object)that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientType, this.compression, this.endpoint, this.headers, this.insecure, this.samplingFraction, this.timeout, this.tlsConfig, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientType != null) {
            sb.append("clientType:");
            sb.append(this.clientType + ",");
        }
        if (this.compression != null) {
            sb.append("compression:");
            sb.append(this.compression + ",");
        }
        if (this.endpoint != null) {
            sb.append("endpoint:");
            sb.append(this.endpoint + ",");
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.insecure != null) {
            sb.append("insecure:");
            sb.append(this.insecure + ",");
        }
        if (this.samplingFraction != null) {
            sb.append("samplingFraction:");
            sb.append(this.samplingFraction + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append((Object)((Object)this.tlsConfig) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withInsecure() {
        return this.withInsecure(true);
    }

    public class TlsConfigNested<N>
    extends TLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        TLSConfigBuilder builder;

        TlsConfigNested(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)PrometheusTracingConfigFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }
}

