/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.core.dependent;

import io.debezium.operator.api.model.DebeziumServer;
import io.debezium.operator.api.model.DebeziumServerSpec;
import io.debezium.operator.api.model.runtime.Runtime;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import java.util.Objects;

public class ServiceAccountDependent
extends CRUDKubernetesDependentResource<ServiceAccount, DebeziumServer> {
    private static final String MANAGED_SA_NAME_TEMPLATE = "%s-sa";

    public ServiceAccountDependent() {
        super(ServiceAccount.class);
    }

    protected ServiceAccount desired(DebeziumServer primary, Context<DebeziumServer> context) {
        String saName = ServiceAccountDependent.managedServiceAccountNameFor(primary);
        return ((ServiceAccountBuilder)new ServiceAccountBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(saName)).withNamespace(primary.getMetadata().getNamespace())).build())).build();
    }

    private static String managedServiceAccountNameFor(DebeziumServer primary) {
        String name = primary.getMetadata().getName();
        return MANAGED_SA_NAME_TEMPLATE.formatted(name);
    }

    public static String serviceAccountNameFor(DebeziumServer primary) {
        Runtime runtime = ((DebeziumServerSpec)primary.getSpec()).getRuntime();
        String saName = runtime.getServiceAccount();
        String managedSaName = ServiceAccountDependent.managedServiceAccountNameFor(primary);
        return Objects.requireNonNullElse(saName, managedSaName);
    }
}

