/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.retry;

import io.javaoperatorsdk.operator.api.config.AnnotationConfigurable;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.javaoperatorsdk.operator.processing.retry.GenericRetryExecution;
import io.javaoperatorsdk.operator.processing.retry.GradualRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;

public class GenericRetry
implements Retry,
AnnotationConfigurable<GradualRetry> {
    private int maxAttempts = 5;
    private long initialInterval = 2000L;
    private double intervalMultiplier = 1.5;
    private long maxInterval = GradualRetry.DEFAULT_MAX_INTERVAL;
    public static final Retry DEFAULT = new GenericRetry();

    public static GenericRetry defaultLimitedExponentialRetry() {
        return (GenericRetry)DEFAULT;
    }

    public static GenericRetry noRetry() {
        return new GenericRetry().setMaxAttempts(0);
    }

    @Deprecated(forRemoval=true)
    public static Retry fromConfiguration(RetryConfiguration configuration) {
        return configuration == null ? GenericRetry.defaultLimitedExponentialRetry() : new GenericRetry().setInitialInterval(configuration.getInitialInterval()).setMaxAttempts(configuration.getMaxAttempts()).setIntervalMultiplier(configuration.getIntervalMultiplier()).setMaxInterval(configuration.getMaxInterval());
    }

    public static GenericRetry every10second10TimesRetry() {
        return new GenericRetry().withLinearRetry().setMaxAttempts(10).setInitialInterval(10000L);
    }

    @Override
    public GenericRetryExecution initExecution() {
        return new GenericRetryExecution(this);
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public GenericRetry setMaxAttempts(int maxRetryAttempts) {
        this.maxAttempts = maxRetryAttempts;
        return this;
    }

    public long getInitialInterval() {
        return this.initialInterval;
    }

    public GenericRetry setInitialInterval(long initialInterval) {
        this.initialInterval = initialInterval;
        return this;
    }

    public double getIntervalMultiplier() {
        return this.intervalMultiplier;
    }

    public GenericRetry setIntervalMultiplier(double intervalMultiplier) {
        this.intervalMultiplier = intervalMultiplier;
        return this;
    }

    public long getMaxInterval() {
        return this.maxInterval;
    }

    public GenericRetry setMaxInterval(long maxInterval) {
        this.maxInterval = maxInterval;
        return this;
    }

    public GenericRetry withoutMaxInterval() {
        this.maxInterval = -1L;
        return this;
    }

    public GenericRetry withoutMaxAttempts() {
        return this.setMaxAttempts(-1);
    }

    public GenericRetry withLinearRetry() {
        this.intervalMultiplier = 1.0;
        return this;
    }

    @Override
    public void initFrom(GradualRetry configuration) {
        this.initialInterval = configuration.initialInterval();
        this.maxAttempts = configuration.maxAttempts();
        this.intervalMultiplier = configuration.intervalMultiplier();
        this.maxInterval = configuration.maxInterval() == Long.MAX_VALUE ? GradualRetry.DEFAULT_MAX_INTERVAL : configuration.maxInterval();
    }
}

