/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.GenericKubernetesResourceMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.ResourceUpdaterMatcher;
import java.util.Map;

public class GenericResourceUpdaterMatcher<R extends HasMetadata>
implements ResourceUpdaterMatcher<R> {
    private static final String METADATA = "metadata";
    private static final ResourceUpdaterMatcher<?> INSTANCE = new GenericResourceUpdaterMatcher();

    protected GenericResourceUpdaterMatcher() {
    }

    public static <R extends HasMetadata> ResourceUpdaterMatcher<R> updaterMatcherFor(Class<R> resourceType) {
        return INSTANCE;
    }

    @Override
    public R updateResource(R actual, R desired, Context<?> context) {
        KubernetesSerialization kubernetesSerialization = context.getClient().getKubernetesSerialization();
        Map actualMap = (Map)kubernetesSerialization.convertValue(actual, Map.class);
        Map desiredMap = (Map)kubernetesSerialization.convertValue(desired, Map.class);
        Object metadata = actualMap.remove(METADATA);
        actualMap.replaceAll((k, v) -> desiredMap.get(k));
        actualMap.putAll(desiredMap);
        actualMap.put(METADATA, metadata);
        HasMetadata clonedActual = (HasMetadata)kubernetesSerialization.convertValue((Object)actualMap, desired.getClass());
        GenericResourceUpdaterMatcher.updateLabelsAndAnnotation(clonedActual, desired);
        return (R)clonedActual;
    }

    @Override
    public boolean matches(R actual, R desired, Context<?> context) {
        return GenericKubernetesResourceMatcher.match(desired, actual, true, false, false, context).matched();
    }

    public static <K extends HasMetadata> void updateLabelsAndAnnotation(K actual, K desired) {
        actual.getMetadata().getLabels().putAll(desired.getMetadata().getLabels());
        actual.getMetadata().getAnnotations().putAll(desired.getMetadata().getAnnotations());
    }
}

