/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.AbstractEventSourceHolderDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.BulkDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.DependentResourceWithExplicitState;
import io.javaoperatorsdk.operator.processing.dependent.Matcher;
import io.javaoperatorsdk.operator.processing.event.EventSourceRetriever;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.ResourceEventSource;
import io.javaoperatorsdk.operator.processing.event.source.informer.InformerEventSource;
import java.util.Optional;

public abstract class AbstractExternalDependentResource<R, P extends HasMetadata, T extends ResourceEventSource<R, P>>
extends AbstractEventSourceHolderDependentResource<R, P, T> {
    private final boolean isDependentResourceWithExplicitState = this instanceof DependentResourceWithExplicitState;
    private final boolean isBulkDependentResource = this instanceof BulkDependentResource;
    private DependentResourceWithExplicitState dependentResourceWithExplicitState;
    private InformerEventSource<?, P> externalStateEventSource;

    protected AbstractExternalDependentResource(Class<R> resourceType) {
        super(resourceType);
        if (this.isDependentResourceWithExplicitState) {
            this.dependentResourceWithExplicitState = (DependentResourceWithExplicitState)((Object)this);
        }
    }

    @Override
    public void resolveEventSource(EventSourceRetriever<P> eventSourceRetriever) {
        super.resolveEventSource(eventSourceRetriever);
        if (this.isDependentResourceWithExplicitState) {
            String eventSourceName = this.dependentResourceWithExplicitState.eventSourceName().orElse(null);
            this.externalStateEventSource = (InformerEventSource)eventSourceRetriever.getResourceEventSourceFor(this.dependentResourceWithExplicitState.stateResourceClass(), eventSourceName);
        }
    }

    @Override
    protected void onCreated(P primary, R created, Context<P> context) {
        super.onCreated(primary, created, context);
        if (this instanceof DependentResourceWithExplicitState) {
            this.handleExplicitStateCreation(primary, created, context);
        }
    }

    @Override
    public void delete(P primary, Context<P> context) {
        if (this.isDependentResourceWithExplicitState && !this.isBulkDependentResource) {
            Optional secondary = this.getSecondaryResource(primary, context);
            super.delete(primary, context);
            this.handleExplicitStateDelete(primary, secondary.orElse(null), context);
        } else {
            super.delete(primary, context);
        }
    }

    private void handleExplicitStateDelete(P primary, R secondary, Context<P> context) {
        Object res = this.dependentResourceWithExplicitState.stateResource(primary, secondary);
        context.getClient().resource(res).delete();
    }

    protected void handleExplicitStateCreation(P primary, R created, Context<P> context) {
        Object resource = this.dependentResourceWithExplicitState.stateResource(primary, created);
        HasMetadata stateResource = (HasMetadata)context.getClient().resource(resource).create();
        if (this.externalStateEventSource != null) {
            this.externalStateEventSource.handleRecentResourceCreate(ResourceID.fromResource(primary), stateResource);
        }
    }

    @Override
    public Matcher.Result<R> match(R resource, P primary, Context<P> context) {
        Object desired = this.desired(primary, context);
        return Matcher.Result.computed(resource.equals(desired), desired);
    }

    public void deleteTargetResource(P primary, R resource, String key, Context<P> context) {
        if (this.isDependentResourceWithExplicitState) {
            context.getClient().resource(this.dependentResourceWithExplicitState.stateResource(primary, resource)).delete();
        }
        this.handleDeleteTargetResource(primary, resource, key, context);
    }

    public void handleDeleteTargetResource(P primary, R resource, String key, Context<P> context) {
        throw new IllegalStateException("Override this method in case you manage an bulk resource");
    }

    protected InformerEventSource getExternalStateEventSource() {
        return this.externalStateEventSource;
    }
}

