/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.reconciler;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ResourceDiscriminator;
import io.javaoperatorsdk.operator.processing.event.source.informer.InformerEventSource;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class IndexDiscriminator<R extends HasMetadata, P extends HasMetadata>
implements ResourceDiscriminator<R, P> {
    private final String indexName;
    private final String eventSourceName;
    private final Function<P, String> keyMapper;

    public IndexDiscriminator(String indexName, Function<P, String> keyMapper) {
        this(indexName, null, keyMapper);
    }

    public IndexDiscriminator(String indexName, String eventSourceName, Function<P, String> keyMapper) {
        this.indexName = indexName;
        this.eventSourceName = eventSourceName;
        this.keyMapper = keyMapper;
    }

    @Override
    public Optional<R> distinguish(Class<R> resource, P primary, Context<P> context) {
        InformerEventSource eventSource = (InformerEventSource)context.eventSourceRetriever().getResourceEventSourceFor(resource, this.eventSourceName);
        List resources = eventSource.byIndex(this.indexName, this.keyMapper.apply(primary));
        if (resources.isEmpty()) {
            return Optional.empty();
        }
        if (resources.size() > 1) {
            throw new IllegalStateException("More than one resource found");
        }
        return Optional.of((HasMetadata)resources.get(0));
    }
}

