/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.docs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.debezium.operator.docs.Processing;
import io.debezium.operator.docs.annotations.Documented;
import io.debezium.operator.docs.model.Documentation;
import io.debezium.operator.docs.output.DocumentationFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public abstract class AbstractDocsProcessor
extends AbstractProcessor {
    private final Documentation documentation;
    private final String file;
    private final Set<String> knownTypes;

    public AbstractDocsProcessor(String file, String title) {
        this.documentation = new Documentation(title);
        this.knownTypes = new HashSet<String>();
        this.file = file;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(Documented.class.getCanonicalName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(typeElement);
            Set<TypeElement> types = ElementFilter.typesIn(annotated);
            this.setKnownTypes(types);
            this.documentTypes(types);
            this.writeDocFile(this.file);
        }
        return false;
    }

    protected void writeDocFile(String fileName) {
        try {
            String content = this.formatter().formatted(this.documentation);
            FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "docs", fileName, new Element[0]);
            try (PrintWriter out = new PrintWriter(resource.openWriter());){
                out.println(content);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void documentTypes(Collection<TypeElement> types) {
        types.stream().filter(this::isNotHidden).map(this::documentType).forEach(this.documentation::addTypeDescription);
    }

    protected Documentation.TypeDescription documentType(TypeElement element) {
        String name = this.name(element);
        Documentation.TypeDescriptionBuilder description = this.typeDescriptionBuilder(name);
        this.presentFields(element).stream().map(this::createFieldDocs).forEach(description::addFieldDescription);
        this.additionalFields(element).stream().map(this::createFieldDocs).forEach(description::addFieldDescription);
        return description.build();
    }

    protected List<Documented.Field> additionalFields(TypeElement element) {
        return this.documentedTypeInfo(element).stream().map(Documented::fields).flatMap(Stream::of).toList();
    }

    protected List<VariableElement> presentFields(TypeElement element) {
        return Processing.enclosedElements(element, ElementKind.FIELD, VariableElement.class).filter(this::isDocumentedField).toList();
    }

    private void setKnownTypes(Collection<TypeElement> types) {
        types.stream().filter(this::isNotHidden).map(this::name).forEach(this.knownTypes::add);
    }

    protected String name(TypeElement type) {
        String fullName = String.valueOf(type.getSimpleName());
        return this.simpleName(fullName);
    }

    protected String name(Element element) {
        return String.valueOf(element.getSimpleName());
    }

    protected String simpleName(String fullName) {
        int dot = fullName.lastIndexOf(46) + 1;
        return fullName.substring(dot);
    }

    protected Optional<Documented.Field> documentedFieldInfo(Element element) {
        return Processing.annotation(element, Documented.Field.class);
    }

    protected Optional<JsonPropertyDescription> jsonPropertyDescription(Element element) {
        return Processing.annotation(element, JsonPropertyDescription.class);
    }

    protected Optional<JsonProperty> jsonProperty(Element element) {
        return Processing.annotation(element, JsonProperty.class);
    }

    protected Optional<Documented> documentedTypeInfo(TypeMirror type) {
        return Processing.asElement(type).flatMap(e -> Processing.annotation(e, Documented.class));
    }

    protected Optional<Documented> documentedTypeInfo(TypeElement type) {
        return Processing.annotation(type, Documented.class);
    }

    protected boolean isDocumentedField(Element field) {
        return Processing.isAnnotated(field, Documented.Field.class) || Processing.isAnnotated(field, JsonProperty.class) || Processing.isAnnotated(field, JsonPropertyDescription.class);
    }

    protected boolean isNotHidden(TypeElement element) {
        return this.documentedTypeInfo(element).map(Documented::hidden).map(hidden -> hidden == false).orElse(true);
    }

    protected boolean isKnownType(String name) {
        return this.knownTypes.contains(name);
    }

    protected String fieldDefaultValue(Element element) {
        return Optional.empty().or(() -> this.documentedFieldInfo(element).map(Documented.Field::defaultValue).filter(Predicate.not(String::isEmpty))).or(() -> this.jsonProperty(element).map(JsonProperty::defaultValue).filter(Predicate.not(String::isEmpty))).orElse("");
    }

    protected String fieldDescription(Element element) {
        return Optional.empty().or(() -> this.documentedFieldInfo(element).map(Documented.Field::description).filter(Predicate.not(String::isEmpty))).or(() -> this.jsonPropertyDescription(element).map(JsonPropertyDescription::value).filter(Predicate.not(String::isEmpty))).orElse("");
    }

    protected String fieldType(VariableElement field) {
        TypeMirror type = field.asType();
        return Optional.empty().or(() -> this.explicitFieldTypeName(field)).or(() -> this.explicitTypeName(type)).or(() -> this.enumTypeName(type)).or(() -> this.declaredTypeName(type)).orElseGet(() -> this.typeName(type));
    }

    protected Optional<String> explicitFieldTypeName(VariableElement field) {
        return this.documentedFieldInfo(field).map(Documented.Field::type).filter(Predicate.not(String::isEmpty));
    }

    protected Optional<String> explicitTypeName(TypeMirror type) {
        return this.documentedTypeInfo(type).map(Documented::name).filter(Predicate.not(String::isEmpty));
    }

    protected Optional<String> enumTypeName(TypeMirror type) {
        return Processing.asEnum(type).map(this::enumConstantNames).map(names -> String.join((CharSequence)",", names));
    }

    protected Optional<String> declaredTypeName(TypeMirror mirror) {
        return Processing.asDeclared(mirror).map(this::genericTypeName);
    }

    protected String typeName(TypeMirror type) {
        String fullName = type.toString();
        return this.simpleName(fullName);
    }

    protected String genericTypeName(DeclaredType type) {
        TypeMirror erasure = this.processingEnv.getTypeUtils().erasure(type);
        StringJoiner typeArgs = new StringJoiner(", ", "<", ">").setEmptyValue("");
        Processing.typeArguments(type).map(this::typeName).forEach(typeArgs::add);
        return this.typeName(erasure) + typeArgs;
    }

    protected List<String> enumConstantNames(TypeElement type) {
        return Processing.enclosedElements(type, ElementKind.ENUM_CONSTANT).map(this::name).map(String::toLowerCase).toList();
    }

    protected String fieldTypeReference(VariableElement field) {
        TypeMirror type = field.asType();
        return Optional.empty().or(() -> this.typeErasureReference(type)).or(() -> this.typeArgumentReference(type)).orElse(null);
    }

    protected String fieldExternalTypeReference(VariableElement field) {
        return this.documentedFieldInfo(field).map(this::fieldExternalTypeReference).orElse(null);
    }

    protected String fieldExternalTypeReference(Documented.Field field) {
        return Optional.empty().or(() -> this.k8TypeReference(field.k8Ref())).orElse(null);
    }

    protected Optional<String> k8TypeReference(String slug) {
        if (slug.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of("https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.28/#" + slug);
    }

    protected Optional<String> typeErasureReference(TypeMirror type) {
        TypeMirror erasure = this.processingEnv.getTypeUtils().erasure(type);
        return Processing.asDeclared(erasure).map(this::typeName).filter(this::isKnownType);
    }

    protected Optional<String> typeArgumentReference(TypeMirror type) {
        return Processing.asDeclared(type).map(t -> Processing.typeArguments(t, this::typeName)).map(s -> s.filter(this::isKnownType)).flatMap(Stream::findFirst);
    }

    protected Documentation.TypeDescriptionBuilder typeDescriptionBuilder(String name) {
        return new Documentation.TypeDescriptionBuilder(name);
    }

    protected Documentation.FieldDescription createFieldDocs(Documented.Field field) {
        return new Documentation.FieldDescription(field.name(), field.type(), field.type(), this.fieldExternalTypeReference(field), field.defaultValue(), field.description());
    }

    protected Documentation.FieldDescription createFieldDocs(VariableElement field) {
        return new Documentation.FieldDescription(this.name(field), this.fieldType(field), this.fieldTypeReference(field), this.fieldExternalTypeReference(field), this.fieldDefaultValue(field), this.fieldDescription(field));
    }

    protected abstract DocumentationFormatter formatter();
}

