/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class TransformingItemStore<R extends HasMetadata>
implements ItemStore<R> {
    private final Function<R, String> keyFunction;
    private final UnaryOperator<R> transformationFunction;
    private final ConcurrentHashMap<String, R> store = new ConcurrentHashMap();

    public TransformingItemStore(UnaryOperator<R> transformationFunction) {
        this(Cache::metaNamespaceKeyFunc, transformationFunction);
    }

    public TransformingItemStore(Function<R, String> keyFunction, UnaryOperator<R> transformationFunction) {
        this.keyFunction = keyFunction;
        this.transformationFunction = transformationFunction;
    }

    public String getKey(R obj) {
        return this.keyFunction.apply(obj);
    }

    public R put(String key, R obj) {
        String originalName = obj.getMetadata().getName();
        String originalNamespace = obj.getMetadata().getNamespace();
        String originalResourceVersion = obj.getMetadata().getResourceVersion();
        HasMetadata transformed = (HasMetadata)this.transformationFunction.apply(obj);
        transformed.getMetadata().setName(originalName);
        transformed.getMetadata().setNamespace(originalNamespace);
        transformed.getMetadata().setResourceVersion(originalResourceVersion);
        return (R)this.store.put(key, transformed);
    }

    public R remove(String key) {
        return (R)((HasMetadata)this.store.remove(key));
    }

    public Stream<String> keySet() {
        return this.store.keySet().stream();
    }

    public Stream<R> values() {
        return this.store.values().stream();
    }

    public R get(String key) {
        return (R)((HasMetadata)this.store.get(key));
    }

    public int size() {
        return this.store.size();
    }

    public boolean isFullState() {
        return false;
    }
}

