/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.KubernetesResourceUtils;
import io.javaoperatorsdk.operator.processing.MDCUtils;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.controller.InternalEventFilters;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceAction;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEvent;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEventFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnDeleteFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.event.source.informer.ManagedInformerEventSource;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerResourceEventSource<T extends HasMetadata>
extends ManagedInformerEventSource<T, T, ControllerConfiguration<T>>
implements ResourceEventHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(ControllerResourceEventSource.class);
    private final Controller<T> controller;
    private final ResourceEventFilter<T> legacyFilters;

    public ControllerResourceEventSource(Controller<T> controller) {
        super(controller.getCRClient(), controller.getConfiguration(), false);
        this.controller = controller;
        ControllerConfiguration<T> config = controller.getConfiguration();
        OnUpdateFilter internalOnUpdateFilter = InternalEventFilters.onUpdateFinalizerNeededAndApplied(controller.useFinalizer(), config.getFinalizerName()).or(InternalEventFilters.onUpdateGenerationAware(config.isGenerationAware())).or(InternalEventFilters.onUpdateMarkedForDeletion());
        this.legacyFilters = config.getEventFilter();
        config.onAddFilter().ifPresent(this::setOnAddFilter);
        config.onUpdateFilter().ifPresentOrElse(filter -> this.setOnUpdateFilter(filter.and(internalOnUpdateFilter)), () -> this.setOnUpdateFilter(internalOnUpdateFilter));
        config.genericFilter().ifPresent(this::setGenericFilter);
        this.setConfigurationService(config.getConfigurationService());
    }

    @Override
    public synchronized void start() {
        try {
            super.start();
        }
        catch (KubernetesClientException e) {
            ReconcilerUtils.handleKubernetesClientException((Exception)((Object)e), this.controller.getConfiguration().getResourceTypeName());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventReceived(ResourceAction action, T resource, T oldResource) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Event received for resource: {} version: {} uuid: {} action: {}", new Object[]{ResourceID.fromResource(resource), KubernetesResourceUtils.getVersion(resource), resource.getMetadata().getUid(), action});
                log.trace("Event Old resource: {},\n new resource: {}", oldResource, resource);
            }
            MDCUtils.addResourceInfo(resource);
            this.controller.getEventSourceManager().broadcastOnResourceEvent(action, resource, oldResource);
            if ((this.legacyFilters == null || this.legacyFilters.acceptChange(this.controller, oldResource, resource)) && this.isAcceptedByFilters(action, resource, oldResource)) {
                this.getEventHandler().handleEvent(new ResourceEvent(action, ResourceID.fromResource(resource), (HasMetadata)resource));
            } else {
                log.debug("Skipping event handling resource {}", (Object)ResourceID.fromResource(resource));
            }
        }
        finally {
            MDCUtils.removeResourceInfo();
        }
    }

    private boolean isAcceptedByFilters(ResourceAction action, T resource, T oldResource) {
        if (this.genericFilter != null && !this.genericFilter.accept(resource)) {
            return false;
        }
        switch (action) {
            case ADDED: {
                return this.onAddFilter == null || this.onAddFilter.accept(resource);
            }
            case UPDATED: {
                return this.onUpdateFilter.accept(resource, oldResource);
            }
        }
        return true;
    }

    @Override
    public void onAdd(T resource) {
        super.onAdd(resource);
        this.eventReceived(ResourceAction.ADDED, resource, null);
    }

    @Override
    public void onUpdate(T oldCustomResource, T newCustomResource) {
        super.onUpdate(oldCustomResource, newCustomResource);
        this.eventReceived(ResourceAction.UPDATED, newCustomResource, oldCustomResource);
    }

    @Override
    public void onDelete(T resource, boolean b) {
        super.onDelete(resource, b);
        this.eventReceived(ResourceAction.DELETED, resource, null);
    }

    @Override
    public Optional<T> getSecondaryResource(T primary) {
        throw new IllegalStateException("This method should not be called here. Primary: " + primary);
    }

    @Override
    public Set<T> getSecondaryResources(T primary) {
        throw new IllegalStateException("This method should not be called here. Primary: " + primary);
    }

    @Override
    public void setOnDeleteFilter(OnDeleteFilter<? super T> onDeleteFilter) {
        throw new IllegalStateException("onDeleteFilter is not supported for controller resource event source");
    }
}

