/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnDeleteFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import java.util.Optional;
import java.util.Set;

public interface ResourceEventSource<R, P extends HasMetadata>
extends EventSource {
    public Class<R> resourceType();

    default public Optional<R> getSecondaryResource(P primary) {
        Set<R> resources = this.getSecondaryResources(primary);
        if (resources.isEmpty()) {
            return Optional.empty();
        }
        if (resources.size() == 1) {
            return Optional.of(resources.iterator().next());
        }
        throw new IllegalStateException("More than 1 secondary resource related to primary");
    }

    public Set<R> getSecondaryResources(P var1);

    public void setOnAddFilter(OnAddFilter<? super R> var1);

    public void setOnUpdateFilter(OnUpdateFilter<? super R> var1);

    public void setOnDeleteFilter(OnDeleteFilter<? super R> var1);

    public void setGenericFilter(GenericFilter<? super R> var1);
}

