/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.workflow;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Deleter;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.api.reconciler.dependent.ReconcileResult;
import io.javaoperatorsdk.operator.processing.dependent.workflow.AbstractWorkflowExecutor;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DependentResourceNode;
import io.javaoperatorsdk.operator.processing.dependent.workflow.NodeExecutor;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Workflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.WorkflowReconcileResult;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowReconcileExecutor<P extends HasMetadata>
extends AbstractWorkflowExecutor<P> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowReconcileExecutor.class);
    private static final String RECONCILE = "reconcile";
    private static final String DELETE = "delete";
    private final Set<DependentResourceNode> notReady = ConcurrentHashMap.newKeySet();
    private final Set<DependentResourceNode> markedForDelete = ConcurrentHashMap.newKeySet();
    private final Set<DependentResourceNode> deletePostConditionNotMet = ConcurrentHashMap.newKeySet();
    private final Set<DependentResourceNode> reconciled = ConcurrentHashMap.newKeySet();
    private final Map<DependentResource, ReconcileResult> reconcileResults = new ConcurrentHashMap<DependentResource, ReconcileResult>();

    public WorkflowReconcileExecutor(Workflow<P> workflow, P primary, Context<P> context) {
        super(workflow, primary, context);
    }

    public synchronized WorkflowReconcileResult reconcile() {
        for (DependentResourceNode dependentResourceNode : this.workflow.getTopLevelDependentResources()) {
            this.handleReconcile(dependentResourceNode);
        }
        this.waitForScheduledExecutionsToRun();
        return this.createReconcileResult();
    }

    @Override
    protected Logger logger() {
        return log;
    }

    private synchronized <R> void handleReconcile(DependentResourceNode<R, P> dependentResourceNode) {
        log.debug("Submitting for reconcile: {} primaryID: {}", dependentResourceNode, (Object)this.primaryID);
        if (this.alreadyVisited(dependentResourceNode) || this.isExecutingNow(dependentResourceNode) || !this.allParentsReconciledAndReady(dependentResourceNode) || this.markedForDelete.contains(dependentResourceNode) || this.hasErroredParent(dependentResourceNode)) {
            log.debug("Skipping submit of: {}, primaryID: {}", dependentResourceNode, (Object)this.primaryID);
            return;
        }
        boolean activationConditionMet = this.isConditionMet(dependentResourceNode.getActivationCondition(), dependentResourceNode.getDependentResource());
        this.registerOrDeregisterEventSourceBasedOnActivation(activationConditionMet, dependentResourceNode);
        boolean reconcileConditionMet = true;
        if (activationConditionMet) {
            reconcileConditionMet = this.isConditionMet(dependentResourceNode.getReconcilePrecondition(), dependentResourceNode.getDependentResource());
        }
        if (!reconcileConditionMet || !activationConditionMet) {
            this.handleReconcileOrActivationConditionNotMet(dependentResourceNode, activationConditionMet);
        } else {
            this.submit(dependentResourceNode, new NodeReconcileExecutor<R>(dependentResourceNode), RECONCILE);
        }
    }

    private synchronized void handleDelete(DependentResourceNode dependentResourceNode) {
        log.debug("Submitting for delete: {}", (Object)dependentResourceNode);
        if (this.alreadyVisited(dependentResourceNode) || this.isExecutingNow(dependentResourceNode) || !this.markedForDelete.contains(dependentResourceNode) || !this.allDependentsDeletedAlready(dependentResourceNode)) {
            log.debug("Skipping submit for delete of: {} primaryID: {} ", (Object)dependentResourceNode, (Object)this.primaryID);
            return;
        }
        this.submit(dependentResourceNode, new NodeDeleteExecutor(dependentResourceNode), DELETE);
    }

    private boolean allDependentsDeletedAlready(DependentResourceNode<?, P> dependentResourceNode) {
        List<DependentResourceNode> dependents = dependentResourceNode.getParents();
        return dependents.stream().allMatch(d -> this.alreadyVisited(d) && !this.notReady.contains(d) && !this.isInError(d) && !this.deletePostConditionNotMet.contains(d));
    }

    private synchronized void setAlreadyReconciledButNotReady(DependentResourceNode<?, P> dependentResourceNode) {
        log.debug("Setting already reconciled but not ready for: {}", dependentResourceNode);
        this.markAsVisited(dependentResourceNode);
        this.notReady.add(dependentResourceNode);
    }

    private synchronized void handleDependentDeleted(DependentResourceNode<?, P> dependentResourceNode) {
        dependentResourceNode.getDependsOn().forEach(dr -> {
            log.debug("Handle deleted for: {} with dependent: {} primaryID: {}", new Object[]{dr, dependentResourceNode, this.primaryID});
            this.handleDelete((DependentResourceNode)dr);
        });
    }

    private synchronized void handleDependentsReconcile(DependentResourceNode<?, P> dependentResourceNode) {
        List<DependentResourceNode> dependents = dependentResourceNode.getParents();
        dependents.forEach(d -> {
            log.debug("Handle reconcile for dependent: {} of parent:{} primaryID: {}", new Object[]{d, dependentResourceNode, this.primaryID});
            this.handleReconcile((DependentResourceNode)d);
        });
    }

    private void handleReconcileOrActivationConditionNotMet(DependentResourceNode<?, P> dependentResourceNode, boolean activationConditionMet) {
        HashSet<DependentResourceNode> bottomNodes = new HashSet<DependentResourceNode>();
        this.markDependentsForDelete(dependentResourceNode, bottomNodes, activationConditionMet);
        bottomNodes.forEach(this::handleDelete);
    }

    private void markDependentsForDelete(DependentResourceNode<?, P> dependentResourceNode, Set<DependentResourceNode> bottomNodes, boolean activationConditionMet) {
        List<DependentResourceNode> dependents = dependentResourceNode.getParents();
        if (activationConditionMet) {
            this.markedForDelete.add(dependentResourceNode);
            if (dependents.isEmpty()) {
                bottomNodes.add(dependentResourceNode);
            } else {
                dependents.forEach(d -> this.markDependentsForDelete((DependentResourceNode<?, P>)d, bottomNodes, true));
            }
        } else {
            this.markAsVisited(dependentResourceNode);
            if (dependents.isEmpty()) {
                this.handleNodeExecutionFinish(dependentResourceNode);
            } else {
                dependents.forEach(d -> this.markDependentsForDelete((DependentResourceNode<?, P>)d, bottomNodes, true));
            }
        }
    }

    private boolean allParentsReconciledAndReady(DependentResourceNode<?, ?> dependentResourceNode) {
        return dependentResourceNode.getDependsOn().isEmpty() || dependentResourceNode.getDependsOn().stream().allMatch(d -> this.alreadyVisited(d) && !this.notReady.contains(d));
    }

    private boolean hasErroredParent(DependentResourceNode<?, ?> dependentResourceNode) {
        return !dependentResourceNode.getDependsOn().isEmpty() && dependentResourceNode.getDependsOn().stream().anyMatch(this::isInError);
    }

    private WorkflowReconcileResult createReconcileResult() {
        return new WorkflowReconcileResult(this.reconciled.stream().map(DependentResourceNode::getDependentResource).collect(Collectors.toList()), this.notReady.stream().map(DependentResourceNode::getDependentResource).collect(Collectors.toList()), this.getErroredDependents(), this.reconcileResults);
    }

    private class NodeDeleteExecutor<R>
    extends NodeExecutor<R, P> {
        private NodeDeleteExecutor(DependentResourceNode<R, P> dependentResourceNode) {
            super(dependentResourceNode, WorkflowReconcileExecutor.this);
        }

        @Override
        protected void doRun(DependentResourceNode<R, P> dependentResourceNode, DependentResource<R, P> dependentResource) {
            Optional deletePostCondition = dependentResourceNode.getDeletePostcondition();
            boolean deletePostConditionMet = true;
            if (WorkflowReconcileExecutor.this.isConditionMet(dependentResourceNode.getActivationCondition(), dependentResource)) {
                if (dependentResource instanceof Deleter) {
                    ((Deleter)((Object)dependentResource)).delete(WorkflowReconcileExecutor.this.primary, WorkflowReconcileExecutor.this.context);
                }
                deletePostConditionMet = WorkflowReconcileExecutor.this.isConditionMet(deletePostCondition, dependentResource);
            }
            if (deletePostConditionMet) {
                WorkflowReconcileExecutor.this.markAsVisited(dependentResourceNode);
                WorkflowReconcileExecutor.this.handleDependentDeleted(dependentResourceNode);
            } else {
                WorkflowReconcileExecutor.this.deletePostConditionNotMet.add(dependentResourceNode);
                WorkflowReconcileExecutor.this.markAsVisited(dependentResourceNode);
            }
        }
    }

    private class NodeReconcileExecutor<R>
    extends NodeExecutor<R, P> {
        private NodeReconcileExecutor(DependentResourceNode<R, P> dependentResourceNode) {
            super(dependentResourceNode, WorkflowReconcileExecutor.this);
        }

        @Override
        protected void doRun(DependentResourceNode<R, P> dependentResourceNode, DependentResource<R, P> dependentResource) {
            log.debug("Reconciling for primary: {} node: {} ", (Object)WorkflowReconcileExecutor.this.primaryID, dependentResourceNode);
            ReconcileResult<R> reconcileResult = dependentResource.reconcile(WorkflowReconcileExecutor.this.primary, WorkflowReconcileExecutor.this.context);
            WorkflowReconcileExecutor.this.reconcileResults.put(dependentResource, reconcileResult);
            WorkflowReconcileExecutor.this.reconciled.add(dependentResourceNode);
            boolean ready = WorkflowReconcileExecutor.this.isConditionMet(dependentResourceNode.getReadyPostcondition(), dependentResource);
            if (ready) {
                log.debug("Setting already reconciled for: {} primaryID: {}", dependentResourceNode, (Object)WorkflowReconcileExecutor.this.primaryID);
                WorkflowReconcileExecutor.this.markAsVisited(dependentResourceNode);
                WorkflowReconcileExecutor.this.handleDependentsReconcile(dependentResourceNode);
            } else {
                WorkflowReconcileExecutor.this.setAlreadyReconciledButNotReady(dependentResourceNode);
            }
        }
    }
}

