/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.Utils;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceManager {
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceManager.class);
    public static final int MIN_THREAD_NUMBER = 0;
    private ExecutorService executor;
    private ExecutorService workflowExecutor;
    private ExecutorService cachingExecutorService;
    private boolean started;
    private ConfigurationService configurationService;

    ExecutorServiceManager(ConfigurationService configurationService) {
        this.start(configurationService);
    }

    public <T> void boundedExecuteAndWaitForAllToComplete(Stream<T> stream, Function<T, Void> task, Function<T, String> threadNamer) {
        ExecutorServiceManager.executeAndWaitForAllToComplete(stream, task, threadNamer, this.cachingExecutorService());
    }

    public static <T> void executeAndWaitForAllToComplete(Stream<T> stream, Function<T, Void> task, Function<T, String> threadNamer, ExecutorService executorService) {
        InstrumentedExecutorService instrumented = new InstrumentedExecutorService(executorService);
        try {
            instrumented.invokeAll(stream.map(item -> () -> {
                Thread thread = Thread.currentThread();
                String name = thread.getName();
                thread.setName((String)threadNamer.apply(item));
                try {
                    task.apply(item);
                    Void void_ = null;
                    return void_;
                }
                finally {
                    thread.setName(name);
                }
            }).collect(Collectors.toList())).forEach(f -> {
                try {
                    f.get();
                }
                catch (ExecutionException e) {
                    throw new OperatorException(e);
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            });
        }
        catch (InterruptedException e) {
            log.warn("Interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public ExecutorService reconcileExecutorService() {
        return this.executor;
    }

    public ExecutorService workflowExecutorService() {
        this.lazyInitWorkflowExecutorService();
        return this.workflowExecutor;
    }

    private synchronized void lazyInitWorkflowExecutorService() {
        if (this.workflowExecutor == null) {
            this.workflowExecutor = new InstrumentedExecutorService(this.configurationService.getWorkflowExecutorService());
        }
    }

    public ExecutorService cachingExecutorService() {
        return this.cachingExecutorService;
    }

    public void start(ConfigurationService configurationService) {
        if (!this.started) {
            this.configurationService = configurationService;
            this.cachingExecutorService = Executors.newCachedThreadPool();
            this.executor = new InstrumentedExecutorService(configurationService.getExecutorService());
            this.started = true;
        }
    }

    public void stop(Duration gracefulShutdownTimeout) {
        try {
            log.debug("Closing executor");
            ExecutorService parallelExec = Executors.newFixedThreadPool(3);
            parallelExec.invokeAll(List.of(ExecutorServiceManager.shutdown(this.executor, gracefulShutdownTimeout), ExecutorServiceManager.shutdown(this.workflowExecutor, gracefulShutdownTimeout), ExecutorServiceManager.shutdown(this.cachingExecutorService, gracefulShutdownTimeout)));
            this.workflowExecutor = null;
            parallelExec.shutdownNow();
            this.started = false;
        }
        catch (InterruptedException e) {
            log.debug("Exception closing executor: {}", (Object)e.getLocalizedMessage());
            Thread.currentThread().interrupt();
        }
    }

    private static Callable<Void> shutdown(ExecutorService executorService, Duration gracefulShutdownTimeout) {
        return () -> {
            if (executorService == null) {
                return null;
            }
            executorService.shutdown();
            if (!executorService.awaitTermination(gracefulShutdownTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                executorService.shutdownNow();
            }
            return null;
        };
    }

    private static class InstrumentedExecutorService
    implements ExecutorService {
        private final boolean debug;
        private final ExecutorService executor;

        private InstrumentedExecutorService(ExecutorService executor) {
            if (executor == null) {
                throw new NullPointerException();
            }
            this.executor = executor;
            this.debug = Utils.debugThreadPool();
        }

        @Override
        public void shutdown() {
            if (this.debug) {
                Thread.dumpStack();
            }
            this.executor.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.executor.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.executor.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.executor.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.executor.submit(task);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.executor.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.executor.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.executor.invokeAny(tasks, timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(command);
        }
    }
}

