/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.timer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.AbstractEventSource;
import io.javaoperatorsdk.operator.processing.event.source.ResourceEventAware;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerEventSource<R extends HasMetadata>
extends AbstractEventSource
implements ResourceEventAware<R> {
    private static final Logger log = LoggerFactory.getLogger(TimerEventSource.class);
    private Timer timer;
    private final Map<ResourceID, EventProducerTimeTask> onceTasks = new ConcurrentHashMap<ResourceID, EventProducerTimeTask>();

    public void scheduleOnce(R resource, long delay) {
        this.scheduleOnce(ResourceID.fromResource(resource), delay);
    }

    public void scheduleOnce(ResourceID resourceID, long delay) {
        if (!this.isRunning()) {
            throw new IllegalStateException("The TimerEventSource is not running");
        }
        if (this.onceTasks.containsKey(resourceID)) {
            this.cancelOnceSchedule(resourceID);
        }
        EventProducerTimeTask task = new EventProducerTimeTask(resourceID);
        this.onceTasks.put(resourceID, task);
        this.timer.schedule((TimerTask)task, delay);
    }

    @Override
    public void onResourceDeleted(R resource) {
        this.cancelOnceSchedule(ResourceID.fromResource(resource));
    }

    public void cancelOnceSchedule(ResourceID customResourceUid) {
        TimerTask timerTask = this.onceTasks.remove(customResourceUid);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    @Override
    public void start() {
        if (!this.isRunning()) {
            super.start();
            this.timer = new Timer(true);
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.onceTasks.keySet().forEach(this::cancelOnceSchedule);
            this.timer.cancel();
            super.stop();
        }
    }

    public class EventProducerTimeTask
    extends TimerTask {
        protected final ResourceID customResourceUid;

        public EventProducerTimeTask(ResourceID customResourceUid) {
            this.customResourceUid = customResourceUid;
        }

        @Override
        public void run() {
            if (TimerEventSource.this.isRunning()) {
                log.debug("Producing event for custom resource id: {}", (Object)this.customResourceUid);
                TimerEventSource.this.getEventHandler().handleEvent(new Event(this.customResourceUid));
            }
        }
    }
}

