/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.informer.ManagedInformerEventSource;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryResourceCache<T extends HasMetadata> {
    private static final Logger log = LoggerFactory.getLogger(TemporaryResourceCache.class);
    private static final int MAX_RESOURCE_VERSIONS = 256;
    private final Map<ResourceID, T> cache = new ConcurrentHashMap<ResourceID, T>();
    private final ManagedInformerEventSource<T, ?, ?> managedInformerEventSource;
    private final boolean parseResourceVersions;
    private final Set<String> knownResourceVersions;

    public TemporaryResourceCache(ManagedInformerEventSource<T, ?, ?> managedInformerEventSource, boolean parseResourceVersions) {
        this.managedInformerEventSource = managedInformerEventSource;
        this.parseResourceVersions = parseResourceVersions;
        this.knownResourceVersions = parseResourceVersions ? Collections.newSetFromMap(new LinkedHashMap<String, Boolean>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
                return this.size() >= 256;
            }
        }) : null;
    }

    public synchronized void onEvent(T resource, boolean unknownState) {
        this.cache.computeIfPresent(ResourceID.fromResource(resource), (id, cached) -> unknownState || !this.isLaterResourceVersion((ResourceID)id, (T)cached, resource) ? null : cached);
    }

    public synchronized void putAddedResource(T newResource) {
        this.putResource(newResource, null);
    }

    public synchronized void putResource(T newResource, String previousResourceVersion) {
        if (this.knownResourceVersions != null) {
            this.knownResourceVersions.add(newResource.getMetadata().getResourceVersion());
        }
        ResourceID resourceId = ResourceID.fromResource(newResource);
        HasMetadata cachedResource = this.getResourceFromCache(resourceId).orElse(this.managedInformerEventSource.get(resourceId).orElse(null));
        if (previousResourceVersion == null && cachedResource == null || cachedResource != null && cachedResource.getMetadata().getResourceVersion().equals(previousResourceVersion) || this.isLaterResourceVersion(resourceId, newResource, cachedResource)) {
            log.debug("Temporarily moving ahead to target version {} for resource id: {}", (Object)newResource.getMetadata().getResourceVersion(), (Object)resourceId);
            this.putToCache(newResource, resourceId);
        } else if (this.cache.remove(resourceId) != null) {
            log.debug("Removed an obsolete resource from cache for id: {}", (Object)resourceId);
        }
    }

    public boolean isKnownResourceVersion(T resource) {
        return this.knownResourceVersions != null && this.knownResourceVersions.contains(resource.getMetadata().getResourceVersion());
    }

    private boolean isLaterResourceVersion(ResourceID resourceId, T newResource, T cachedResource) {
        try {
            if (this.parseResourceVersions && Long.parseLong(newResource.getMetadata().getResourceVersion()) > Long.parseLong(cachedResource.getMetadata().getResourceVersion())) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            log.debug("Could not compare resourceVersions {} and {} for {}", new Object[]{newResource.getMetadata().getResourceVersion(), cachedResource.getMetadata().getResourceVersion(), resourceId});
        }
        return false;
    }

    private void putToCache(T resource, ResourceID resourceID) {
        this.cache.put(resourceID == null ? ResourceID.fromResource(resource) : resourceID, resource);
    }

    public synchronized Optional<T> getResourceFromCache(ResourceID resourceID) {
        return Optional.ofNullable((HasMetadata)this.cache.get(resourceID));
    }
}

