/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ResourceConfiguration;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.processing.event.rate.LinearRateLimiter;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEventFilter;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEventFilters;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface ControllerConfiguration<P extends HasMetadata>
extends ResourceConfiguration<P> {
    public static final RateLimiter DEFAULT_RATE_LIMITER = LinearRateLimiter.deactivatedRateLimiter();
    public static final String CONTROLLER_NAME_AS_FIELD_MANAGER = "use_controller_name";

    default public String getName() {
        return ControllerConfiguration.ensureValidName(null, this.getAssociatedReconcilerClassName());
    }

    default public String getFinalizerName() {
        return ReconcilerUtils.getDefaultFinalizerName(this.getResourceClass());
    }

    public static String ensureValidName(String name, String reconcilerClassName) {
        return name != null ? name : ReconcilerUtils.getDefaultReconcilerName(reconcilerClassName);
    }

    public static String ensureValidFinalizerName(String finalizer, String resourceTypeName) {
        if (finalizer != null && !finalizer.isBlank()) {
            if (ReconcilerUtils.isFinalizerValid(finalizer)) {
                return finalizer;
            }
            throw new IllegalArgumentException(finalizer + " is not a valid finalizer. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#finalizers for details");
        }
        return ReconcilerUtils.getDefaultFinalizerName(resourceTypeName);
    }

    default public boolean isGenerationAware() {
        return true;
    }

    public String getAssociatedReconcilerClassName();

    default public Retry getRetry() {
        RetryConfiguration configuration = this.getRetryConfiguration();
        return !RetryConfiguration.DEFAULT.equals(configuration) ? GenericRetry.fromConfiguration(configuration) : GenericRetry.DEFAULT;
    }

    @Deprecated(forRemoval=true)
    default public RetryConfiguration getRetryConfiguration() {
        return RetryConfiguration.DEFAULT;
    }

    default public RateLimiter getRateLimiter() {
        return DEFAULT_RATE_LIMITER;
    }

    @Deprecated(forRemoval=true)
    default public ResourceEventFilter<P> getEventFilter() {
        return ResourceEventFilters.passthrough();
    }

    default public List<DependentResourceSpec> getDependentResources() {
        return Collections.emptyList();
    }

    default public Optional<Duration> maxReconciliationInterval() {
        return Optional.of(Duration.ofHours(10L));
    }

    public ConfigurationService getConfigurationService();

    @Override
    default public Class<P> getResourceClass() {
        return Utils.getFirstTypeArgumentFromSuperClassOrInterface(this.getClass(), ControllerConfiguration.class);
    }

    default public Set<String> getEffectiveNamespaces() {
        return ResourceConfiguration.super.getEffectiveNamespaces(this.getConfigurationService());
    }

    default public String fieldManager() {
        return this.getName();
    }
}

