/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator;

import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.javaoperatorsdk.operator.BuilderUtils;
import io.javaoperatorsdk.operator.MissingCRDException;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ReconcilerUtils {
    private static final String FINALIZER_NAME_SUFFIX = "/finalizer";
    protected static final String MISSING_GROUP_SUFFIX = ".javaoperatorsdk.io";
    private static final String GET_SPEC = "getSpec";
    private static final String SET_SPEC = "setSpec";
    private static final Pattern API_URI_PATTERN = Pattern.compile(".*http(s?)://[^/]*/api(s?)/(\\S*).*");

    private ReconcilerUtils() {
    }

    public static boolean isFinalizerValid(String finalizer) {
        return HasMetadata.validateFinalizer((String)finalizer);
    }

    public static String getResourceTypeNameWithVersion(Class<? extends HasMetadata> resourceClass) {
        String version = HasMetadata.getVersion(resourceClass);
        return ReconcilerUtils.getResourceTypeName(resourceClass) + "/" + version;
    }

    public static String getResourceTypeName(Class<? extends HasMetadata> resourceClass) {
        return HasMetadata.getFullResourceName(resourceClass);
    }

    public static String getDefaultFinalizerName(Class<? extends HasMetadata> resourceClass) {
        return ReconcilerUtils.getDefaultFinalizerName(ReconcilerUtils.getResourceTypeName(resourceClass));
    }

    public static String getDefaultFinalizerName(String resourceName) {
        if (((String)resourceName).indexOf(46) < 0) {
            resourceName = (String)resourceName + MISSING_GROUP_SUFFIX;
        }
        return (String)resourceName + FINALIZER_NAME_SUFFIX;
    }

    public static String getNameFor(Class<? extends Reconciler> reconcilerClass) {
        String name;
        ControllerConfiguration annotation = reconcilerClass.getAnnotation(ControllerConfiguration.class);
        if (annotation != null && !"".equals(name = annotation.name())) {
            return name;
        }
        return ReconcilerUtils.getDefaultNameFor(reconcilerClass);
    }

    public static void checkIfCanAddOwnerReference(HasMetadata owner, HasMetadata resource) {
        if (owner instanceof GenericKubernetesResource || resource instanceof GenericKubernetesResource) {
            return;
        }
        if (owner instanceof Namespaced) {
            if (!(resource instanceof Namespaced)) {
                throw new OperatorException("Cannot add owner reference from a cluster scoped to a namespace scoped resource." + ReconcilerUtils.resourcesIdentifierDescription(owner, resource));
            }
            if (!Objects.equals(owner.getMetadata().getNamespace(), resource.getMetadata().getNamespace())) {
                throw new OperatorException("Cannot add owner reference between two resource in different namespaces." + ReconcilerUtils.resourcesIdentifierDescription(owner, resource));
            }
        }
    }

    private static String resourcesIdentifierDescription(HasMetadata owner, HasMetadata resource) {
        return " Owner name: " + owner.getMetadata().getName() + " Kind: " + owner.getKind() + ", Resource name: " + resource.getMetadata().getName() + " Kind: " + resource.getKind();
    }

    public static String getNameFor(Reconciler reconciler) {
        return ReconcilerUtils.getNameFor(reconciler.getClass());
    }

    public static String getDefaultNameFor(Reconciler reconciler) {
        return ReconcilerUtils.getDefaultNameFor(reconciler.getClass());
    }

    public static String getDefaultNameFor(Class<? extends Reconciler> reconcilerClass) {
        return ReconcilerUtils.getDefaultReconcilerName(reconcilerClass.getSimpleName());
    }

    public static String getDefaultReconcilerName(String reconcilerClassName) {
        int lastDot = reconcilerClassName.lastIndexOf(46);
        if (lastDot > 0) {
            reconcilerClassName = reconcilerClassName.substring(lastDot + 1);
        }
        return reconcilerClassName.toLowerCase(Locale.ROOT);
    }

    public static boolean specsEqual(HasMetadata r1, HasMetadata r2) {
        return ReconcilerUtils.getSpec(r1).equals(ReconcilerUtils.getSpec(r2));
    }

    public static Object getSpec(HasMetadata resource) {
        if (resource instanceof CustomResource) {
            CustomResource cr = (CustomResource)resource;
            return cr.getSpec();
        }
        try {
            Method getSpecMethod = resource.getClass().getMethod(GET_SPEC, new Class[0]);
            return getSpecMethod.invoke((Object)resource, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw ReconcilerUtils.noSpecException(resource, e);
        }
    }

    public static Object setSpec(HasMetadata resource, Object spec) {
        if (resource instanceof CustomResource) {
            CustomResource cr = (CustomResource)resource;
            cr.setSpec(spec);
            return null;
        }
        try {
            Class<?> resourceClass = resource.getClass();
            Method setSpecMethod = spec != null ? resourceClass.getMethod(SET_SPEC, spec.getClass()) : Arrays.stream(resourceClass.getMethods()).filter(method -> SET_SPEC.equals(method.getName())).findFirst().orElseThrow(() -> ReconcilerUtils.noSpecException(resource, null));
            return setSpecMethod.invoke((Object)resource, spec);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw ReconcilerUtils.noSpecException(resource, e);
        }
    }

    private static IllegalStateException noSpecException(HasMetadata resource, ReflectiveOperationException e) {
        return new IllegalStateException("No spec found on resource " + resource.getClass().getName(), e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadYaml(Class<T> clazz, Class loader, String yaml) {
        try (InputStream is = loader.getResourceAsStream(yaml);){
            if (Builder.class.isAssignableFrom(clazz)) {
                T t = BuilderUtils.newBuilder(clazz, Serialization.unmarshal((InputStream)is, BuilderUtils.builderTargetType(clazz)));
                return t;
            }
            Object object = Serialization.unmarshal((InputStream)is, clazz);
            return (T)object;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot find yaml on classpath: " + yaml);
        }
    }

    public static void handleKubernetesClientException(Exception e, String resourceTypeName) {
        KubernetesClientException ke;
        if (e instanceof MissingCRDException) {
            throw (MissingCRDException)e;
        }
        if (e instanceof KubernetesClientException && 404 == (ke = (KubernetesClientException)e).getCode() && (resourceTypeName.equals(ke.getFullResourceName()) || ReconcilerUtils.matchesResourceType(resourceTypeName, ke))) {
            throw new MissingCRDException(resourceTypeName, ke.getVersion(), e.getMessage(), e);
        }
    }

    private static boolean matchesResourceType(String resourceTypeName, KubernetesClientException exception) {
        String fullResourceName = exception.getFullResourceName();
        if (fullResourceName != null) {
            return resourceTypeName.equals(fullResourceName);
        }
        String message = exception.getMessage();
        Matcher regex = API_URI_PATTERN.matcher(message);
        if (regex.matches()) {
            List segments;
            String group = regex.group(3);
            if (group.endsWith(".")) {
                group = group.substring(0, group.length() - 1);
            }
            if ((segments = Arrays.stream(group.split("/")).filter(Predicate.not(String::isEmpty)).collect(Collectors.toUnmodifiableList())).size() != 3) {
                return false;
            }
            String targetResourceName = (String)segments.get(2) + "." + (String)segments.get(0);
            return resourceTypeName.equals(targetResourceName);
        }
        return false;
    }
}

