/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator;

import io.javaoperatorsdk.operator.OperatorException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class BuilderUtils {
    private BuilderUtils() {
    }

    public static final <T, B> B newBuilder(Class<B> builderType, T item) {
        Class<T> builderTargetType = BuilderUtils.builderTargetType(builderType);
        try {
            Constructor<B> constructor = builderType.getDeclaredConstructor(builderTargetType);
            return constructor.newInstance(item);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new OperatorException("Failied to instantiate builder: " + builderType.getCanonicalName() + " using: " + item, e);
        }
    }

    public static <T, B> Class<T> builderTargetType(Class<B> builderType) {
        try {
            Method method = builderType.getDeclaredMethod("build", new Class[0]);
            return method.getReturnType();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new OperatorException("Failied to determine target type for builder: " + builderType.getCanonicalName(), e);
        }
    }
}

