/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.ExceptionHandler;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.health.InformerHealthIndicator;
import io.javaoperatorsdk.operator.health.Status;
import io.javaoperatorsdk.operator.processing.LifecycleAware;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.IndexerResourceCache;
import io.javaoperatorsdk.operator.processing.event.source.informer.Mappers;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InformerWrapper<T extends HasMetadata>
implements LifecycleAware,
IndexerResourceCache<T>,
InformerHealthIndicator {
    private static final Logger log = LoggerFactory.getLogger(InformerWrapper.class);
    private final SharedIndexInformer<T> informer;
    private final Cache<T> cache;
    private final String namespaceIdentifier;
    private final ConfigurationService configurationService;

    public InformerWrapper(SharedIndexInformer<T> informer, ConfigurationService configurationService, String namespaceIdentifier) {
        this.informer = informer;
        this.namespaceIdentifier = namespaceIdentifier;
        this.cache = (Cache)informer.getStore();
        this.configurationService = configurationService;
    }

    @Override
    public void start() throws OperatorException {
        try {
            this.configurationService.getInformerStoppedHandler().ifPresent(ish -> {
                CompletionStage stopped = this.informer.stopped();
                if (stopped == null) {
                    Class apiTypeClass = this.informer.getApiTypeClass();
                    String fullResourceName = HasMetadata.getFullResourceName((Class)apiTypeClass);
                    String version = HasMetadata.getVersion((Class)apiTypeClass);
                    throw new IllegalStateException("Cannot retrieve 'stopped' callback to listen to informer stopping for informer for " + fullResourceName + "/" + version);
                }
                stopped.handle((res, ex) -> {
                    ish.onStop((SharedIndexInformer)this.informer, (Throwable)ex);
                    return null;
                });
            });
            if (!this.configurationService.stopOnInformerErrorDuringStartup()) {
                this.informer.exceptionHandler((b, t) -> !ExceptionHandler.isDeserializationException((Throwable)t));
            }
            Thread thread = Thread.currentThread();
            String name = thread.getName();
            try {
                thread.setName(this.informerInfo() + " " + thread.getId());
                String resourceName = this.informer.getApiTypeClass().getSimpleName();
                log.debug("Starting informer for namespace: {} resource: {}", (Object)this.namespaceIdentifier, (Object)resourceName);
                CompletionStage start = this.informer.start();
                log.trace("Waiting informer to start namespace: {} resource: {}", (Object)this.namespaceIdentifier, (Object)resourceName);
                start.toCompletableFuture().get(this.configurationService.cacheSyncTimeout().toMillis(), TimeUnit.MILLISECONDS);
                log.debug("Started informer for namespace: {} resource: {}", (Object)this.namespaceIdentifier, (Object)resourceName);
            }
            catch (ExecutionException | TimeoutException e) {
                if (this.configurationService.stopOnInformerErrorDuringStartup()) {
                    log.error("Informer startup error. Operator will be stopped. Informer: {}", this.informer, (Object)e);
                    throw new OperatorException(e);
                }
                log.warn("Informer startup error. Will periodically retry. Informer: {}", this.informer, (Object)e);
            }
            catch (InterruptedException e) {
                thread.interrupt();
                throw new IllegalStateException(e);
            }
            finally {
                thread.setName(name);
            }
        }
        catch (Exception e) {
            ReconcilerUtils.handleKubernetesClientException(e, HasMetadata.getFullResourceName((Class)this.informer.getApiTypeClass()));
            throw new OperatorException("Couldn't start informer for " + this.versionedFullResourceName() + " resources", e);
        }
    }

    private String versionedFullResourceName() {
        Class apiTypeClass = this.informer.getApiTypeClass();
        if (apiTypeClass.isAssignableFrom(GenericKubernetesResource.class)) {
            return GenericKubernetesResource.class.getSimpleName();
        }
        return ReconcilerUtils.getResourceTypeNameWithVersion(apiTypeClass);
    }

    @Override
    public void stop() throws OperatorException {
        this.informer.stop();
    }

    @Override
    public Optional<T> get(ResourceID resourceID) {
        return Optional.ofNullable((HasMetadata)this.cache.getByKey(this.getKey(resourceID)));
    }

    private String getKey(ResourceID resourceID) {
        return Cache.namespaceKeyFunc((String)resourceID.getNamespace().orElse(null), (String)resourceID.getName());
    }

    @Override
    public Stream<T> list(Predicate<T> predicate) {
        return this.cache.list().stream().filter(predicate);
    }

    @Override
    public Stream<T> list(String namespace, Predicate<T> predicate) {
        Stream<HasMetadata> stream = this.cache.list().stream().filter(r -> namespace.equals(r.getMetadata().getNamespace()));
        return predicate != null ? stream.filter(predicate) : stream;
    }

    @Override
    public Stream<ResourceID> keys() {
        return this.cache.listKeys().stream().map(Mappers::fromString);
    }

    public void addEventHandler(ResourceEventHandler<T> eventHandler) {
        this.informer.addEventHandler(eventHandler);
    }

    @Override
    public void addIndexers(Map<String, Function<T, List<String>>> indexers) {
        this.informer.getIndexer().addIndexers(indexers);
    }

    @Override
    public List<T> byIndex(String indexName, String indexKey) {
        return this.informer.getIndexer().byIndex(indexName, indexKey);
    }

    public String toString() {
        return this.informerInfo() + " (" + this.informer + ")";
    }

    private String informerInfo() {
        return "InformerWrapper [" + this.versionedFullResourceName() + "]";
    }

    @Override
    public boolean hasSynced() {
        return this.informer.hasSynced();
    }

    @Override
    public boolean isWatching() {
        return this.informer.isWatching();
    }

    @Override
    public boolean isRunning() {
        return this.informer.isRunning();
    }

    @Override
    public Status getStatus() {
        Status status = this.isRunning() && this.hasSynced() && this.isWatching() ? Status.HEALTHY : Status.UNHEALTHY;
        log.debug("Informer status: {} for for type: {}, namespace: {}, details[ is running: {}, has synced: {}, is watching: {} ]", new Object[]{status, this.informer.getApiTypeClass().getSimpleName(), this.namespaceIdentifier, this.isRunning(), this.hasSynced(), this.isWatching()});
        return status;
    }

    @Override
    public String getTargetNamespace() {
        return this.namespaceIdentifier;
    }
}

