/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.workflow;

import io.javaoperatorsdk.operator.AggregatedOperatorException;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import java.util.HashMap;
import java.util.Map;

class WorkflowResult {
    private static final String NUMBER_DELIMITER = "_";
    private final Map<DependentResource, Exception> erroredDependents;

    WorkflowResult(Map<DependentResource, Exception> erroredDependents) {
        this.erroredDependents = erroredDependents;
    }

    public Map<DependentResource, Exception> getErroredDependents() {
        return this.erroredDependents;
    }

    @Deprecated(forRemoval=true)
    public boolean erroredDependentsExists() {
        return !this.erroredDependents.isEmpty();
    }

    public boolean erroredDependentsExist() {
        return !this.erroredDependents.isEmpty();
    }

    public void throwAggregateExceptionIfErrorsPresent() {
        if (this.erroredDependentsExist()) {
            HashMap<String, Exception> exceptionMap = new HashMap<String, Exception>();
            HashMap<String, Integer> numberOfClasses = new HashMap<String, Integer>();
            for (Map.Entry<DependentResource, Exception> entry : this.erroredDependents.entrySet()) {
                String name = entry.getKey().getClass().getName();
                Integer num = numberOfClasses.getOrDefault(name, 0);
                if (num > 0) {
                    exceptionMap.put(name + NUMBER_DELIMITER + num, entry.getValue());
                } else {
                    exceptionMap.put(name, entry.getValue());
                }
                numberOfClasses.put(name, num + 1);
            }
            throw new AggregatedOperatorException("Exception(s) during workflow execution.", exceptionMap);
        }
    }
}

