/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.reconciler;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Workflow;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public interface EventSourceInitializer<P extends HasMetadata> {
    public Map<String, EventSource> prepareEventSources(EventSourceContext<P> var1);

    public static Map<String, EventSource> nameEventSources(EventSource ... eventSources) {
        HashMap<String, EventSource> eventSourceMap = new HashMap<String, EventSource>(eventSources.length);
        for (EventSource eventSource : eventSources) {
            eventSourceMap.put(EventSourceInitializer.generateNameFor(eventSource), eventSource);
        }
        return eventSourceMap;
    }

    public static <K extends HasMetadata> Map<String, EventSource> eventSourcesFromWorkflow(EventSourceContext<K> context, Workflow<K> workflow) {
        HashMap<String, EventSource> result = new HashMap<String, EventSource>();
        for (Map.Entry<String, DependentResource> e : workflow.getDependentResourcesByNameWithoutActivationCondition().entrySet()) {
            Optional eventSource = e.getValue().eventSource(context);
            eventSource.ifPresent(es -> result.put((String)e.getKey(), (EventSource)es));
        }
        return result;
    }

    public static <K extends HasMetadata> Map<String, EventSource> nameEventSourcesFromDependentResource(EventSourceContext<K> context, DependentResource ... dependentResources) {
        return EventSourceInitializer.nameEventSourcesFromDependentResource(context, Arrays.asList(dependentResources));
    }

    public static <K extends HasMetadata> Map<String, EventSource> nameEventSourcesFromDependentResource(EventSourceContext<K> context, Collection<DependentResource> dependentResources) {
        if (dependentResources != null) {
            HashMap<String, EventSource> eventSourceMap = new HashMap<String, EventSource>(dependentResources.size());
            for (DependentResource dependentResource : dependentResources) {
                Optional es = dependentResource.eventSource(context);
                es.ifPresent(e -> eventSourceMap.put(EventSourceInitializer.generateNameFor(e), (EventSource)e));
            }
            return eventSourceMap;
        }
        return Collections.emptyMap();
    }

    public static String generateNameFor(EventSource eventSource) {
        return eventSource.getClass().getName() + "#" + eventSource.hashCode();
    }
}

