/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator;

import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ExecutorServiceManager;
import io.javaoperatorsdk.operator.processing.Controller;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ControllerManager {
    public static final String CANNOT_REGISTER_MULTIPLE_CONTROLLERS_WITH_SAME_NAME_MESSAGE = "Cannot register multiple controllers with same name: ";
    private static final Logger log = LoggerFactory.getLogger(ControllerManager.class);
    private final Map<String, Controller> controllers = new HashMap<String, Controller>();
    private boolean started = false;
    private final ExecutorServiceManager executorServiceManager;

    public ControllerManager(ExecutorServiceManager executorServiceManager) {
        this.executorServiceManager = executorServiceManager;
    }

    public synchronized void shouldStart() {
        if (this.started) {
            return;
        }
        if (this.controllers.isEmpty()) {
            throw new OperatorException("No Controller exists. Exiting!");
        }
    }

    public synchronized void start(boolean startEventProcessor) {
        this.executorServiceManager.boundedExecuteAndWaitForAllToComplete(this.controllers().stream(), c -> {
            c.start(startEventProcessor);
            return null;
        }, c -> "Controller Starter for: " + c.getConfiguration().getName());
        this.started = true;
    }

    public synchronized void stop() {
        this.executorServiceManager.boundedExecuteAndWaitForAllToComplete(this.controllers().stream(), c -> {
            log.debug("closing {}", c);
            c.stop();
            return null;
        }, c -> "Controller Stopper for: " + c.getConfiguration().getName());
        this.started = false;
    }

    public synchronized void startEventProcessing() {
        this.executorServiceManager.boundedExecuteAndWaitForAllToComplete(this.controllers().stream(), c -> {
            c.startEventProcessing();
            return null;
        }, c -> "Event processor starter for: " + c.getConfiguration().getName());
    }

    synchronized void add(Controller controller) {
        ControllerConfiguration configuration = controller.getConfiguration();
        String name = configuration.getName();
        if (this.controllers.containsKey(name)) {
            throw new OperatorException(CANNOT_REGISTER_MULTIPLE_CONTROLLERS_WITH_SAME_NAME_MESSAGE + name);
        }
        this.controllers.put(name, controller);
    }

    synchronized Optional<Controller> get(String name) {
        return Optional.ofNullable(this.controllers.get(name));
    }

    synchronized Collection<Controller> controllers() {
        return this.controllers.values();
    }

    synchronized int size() {
        return this.controllers.size();
    }
}

