/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.core.dependent;

import io.debezium.operator.api.model.DebeziumServer;
import io.debezium.operator.api.model.DebeziumServerSpec;
import io.debezium.operator.api.model.runtime.Runtime;
import io.debezium.operator.api.model.runtime.storage.DataStorage;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import java.util.Objects;

public class PvcDependent
extends CRUDKubernetesDependentResource<PersistentVolumeClaim, DebeziumServer> {
    public static final String MANAGED_PVC_NAME = "%s-data-volume-claim";

    public PvcDependent() {
        super(PersistentVolumeClaim.class);
    }

    protected PersistentVolumeClaim desired(DebeziumServer primary, Context<DebeziumServer> context) {
        PersistentVolumeClaimSpec template = ((DebeziumServerSpec)primary.getSpec()).getRuntime().getTemplates().getVolumeClaim();
        if (template == null) {
            throw new IllegalStateException("Missing PVC template");
        }
        return ((PersistentVolumeClaimBuilder)((PersistentVolumeClaimBuilder)new PersistentVolumeClaimBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(MANAGED_PVC_NAME.formatted(primary.getMetadata().getName()))).withNamespace(primary.getMetadata().getNamespace())).build())).withSpec(template)).build();
    }

    private static String managedPvcNameFor(DebeziumServer primary) {
        String name = primary.getMetadata().getName();
        return MANAGED_PVC_NAME.formatted(name);
    }

    public static String pvcNameFor(DebeziumServer primary) {
        Runtime runtime = ((DebeziumServerSpec)primary.getSpec()).getRuntime();
        DataStorage storage = runtime.getStorage().getData();
        String providedPvcName = storage.getClaimName();
        String managedPvcName = PvcDependent.managedPvcNameFor(primary);
        return Objects.requireNonNullElse(providedPvcName, managedPvcName);
    }
}

