/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.inbound;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.CacheKeyMapper;
import io.javaoperatorsdk.operator.processing.event.source.ExternalResourceCachingEventSource;
import io.javaoperatorsdk.operator.processing.event.source.ResourceEventAware;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CachingInboundEventSource<R, P extends HasMetadata>
extends ExternalResourceCachingEventSource<R, P>
implements ResourceEventAware<P> {
    private final ResourceFetcher<R, P> resourceFetcher;
    private final Set<ResourceID> fetchedForPrimaries = ConcurrentHashMap.newKeySet();

    public CachingInboundEventSource(ResourceFetcher<R, P> resourceFetcher, Class<R> resourceClass, CacheKeyMapper<R> cacheKeyMapper) {
        super(resourceClass, cacheKeyMapper);
        this.resourceFetcher = resourceFetcher;
    }

    public void handleResourceEvent(ResourceID primaryID, Set<R> resources) {
        super.handleResources(primaryID, resources);
    }

    public void handleResourceEvent(ResourceID primaryID, R resource) {
        super.handleResources(primaryID, resource);
    }

    public void handleResourceDeleteEvent(ResourceID primaryID, String resourceID) {
        super.handleDelete(primaryID, Set.of(resourceID));
    }

    @Override
    public void onResourceDeleted(P resource) {
        ResourceID resourceID = ResourceID.fromResource(resource);
        this.fetchedForPrimaries.remove(resourceID);
    }

    private Set<R> getAndCacheResource(P primary) {
        ResourceID primaryID = ResourceID.fromResource(primary);
        Set<R> values = this.resourceFetcher.fetchResources(primary);
        this.handleResources(primaryID, values, false);
        this.fetchedForPrimaries.add(primaryID);
        return values;
    }

    @Override
    public Set<R> getSecondaryResources(P primary) {
        ResourceID primaryID = ResourceID.fromResource(primary);
        Map cachedValue = (Map)this.cache.get(primaryID);
        if (cachedValue != null && !cachedValue.isEmpty()) {
            return new HashSet(cachedValue.values());
        }
        if (this.fetchedForPrimaries.contains(primaryID)) {
            return Collections.emptySet();
        }
        return this.getAndCacheResource(primary);
    }

    public static interface ResourceFetcher<R, P> {
        public Set<R> fetchResources(P var1);
    }
}

