/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Objects;

public class GroupVersionKind {
    private final String group;
    private final String version;
    private final String kind;

    public GroupVersionKind(String apiVersion, String kind) {
        this.kind = kind;
        String[] groupAndVersion = apiVersion.split("/");
        if (groupAndVersion.length == 1) {
            this.group = null;
            this.version = groupAndVersion[0];
        } else {
            this.group = groupAndVersion[0];
            this.version = groupAndVersion[1];
        }
    }

    public GroupVersionKind(String group, String version, String kind) {
        this.group = group;
        this.version = version;
        this.kind = kind;
    }

    public static GroupVersionKind gvkFor(Class<? extends HasMetadata> resourceClass) {
        return new GroupVersionKind(HasMetadata.getGroup(resourceClass), HasMetadata.getVersion(resourceClass), HasMetadata.getKind(resourceClass));
    }

    public String getGroup() {
        return this.group;
    }

    public String getVersion() {
        return this.version;
    }

    public String getKind() {
        return this.kind;
    }

    public String apiVersion() {
        return this.group == null || this.group.isBlank() ? this.version : this.group + "/" + this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupVersionKind that = (GroupVersionKind)o;
        return Objects.equals(this.group, that.group) && Objects.equals(this.version, that.version) && Objects.equals(this.kind, that.kind);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.version, this.kind);
    }

    public String toString() {
        return "GroupVersionKind{group='" + this.group + "', version='" + this.version + "', kind='" + this.kind + "'}";
    }
}

