/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.runtime.config;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import java.util.Iterator;
import java.util.function.Function;

public class KubernetesConfigFallback
extends FallbackConfigSourceInterceptor {
    public KubernetesConfigFallback() {
        super((Function)new FallbackToKubernetesConfig());
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        return context.iterateNames();
    }

    private static class FallbackToKubernetesConfig
    implements Function<String, String> {
        private FallbackToKubernetesConfig() {
        }

        @Override
        public String apply(String name) {
            if (name.startsWith("quarkus.openshift.")) {
                return "quarkus.kubernetes." + name.substring(18);
            }
            if (name.startsWith("quarkus.knative.")) {
                return "quarkus.kubernetes." + name.substring(16);
            }
            return name;
        }
    }
}

