/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.SecondaryToPrimaryMapper;
import io.javaoperatorsdk.operator.processing.event.source.informer.PrimaryToSecondaryIndex;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class DefaultPrimaryToSecondaryIndex<R extends HasMetadata>
implements PrimaryToSecondaryIndex<R> {
    private final SecondaryToPrimaryMapper<R> secondaryToPrimaryMapper;
    private final Map<ResourceID, Set<ResourceID>> index = new HashMap<ResourceID, Set<ResourceID>>();

    public DefaultPrimaryToSecondaryIndex(SecondaryToPrimaryMapper<R> secondaryToPrimaryMapper) {
        this.secondaryToPrimaryMapper = secondaryToPrimaryMapper;
    }

    @Override
    public synchronized void onAddOrUpdate(R resource) {
        Set<ResourceID> primaryResources = this.secondaryToPrimaryMapper.toPrimaryResourceIDs(resource);
        primaryResources.forEach(primaryResource -> {
            Set resourceSet = this.index.computeIfAbsent((ResourceID)primaryResource, pr -> ConcurrentHashMap.newKeySet());
            resourceSet.add(ResourceID.fromResource(resource));
        });
    }

    @Override
    public synchronized void onDelete(R resource) {
        Set<ResourceID> primaryResources = this.secondaryToPrimaryMapper.toPrimaryResourceIDs(resource);
        primaryResources.forEach(primaryResource -> {
            Set<ResourceID> secondaryResources = this.index.get(primaryResource);
            if (secondaryResources != null) {
                secondaryResources.remove(ResourceID.fromResource(resource));
                if (secondaryResources.isEmpty()) {
                    this.index.remove(primaryResource);
                }
            }
        });
    }

    @Override
    public synchronized Set<ResourceID> getSecondaryResources(ResourceID primary) {
        Set<ResourceID> resourceIDs = this.index.get(primary);
        if (resourceIDs == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(resourceIDs);
    }
}

