/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config.dependent;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class DependentResourceSpec<R, P extends HasMetadata> {
    private final Class<? extends DependentResource<R, P>> dependentResourceClass;
    private final String name;
    private final Set<String> dependsOn;
    private final Condition<?, ?> readyCondition;
    private final Condition<?, ?> reconcileCondition;
    private final Condition<?, ?> deletePostCondition;
    private final Condition<?, ?> activationCondition;
    private final String useEventSourceWithName;

    public DependentResourceSpec(Class<? extends DependentResource<R, P>> dependentResourceClass, String name, Set<String> dependsOn, Condition<?, ?> readyCondition, Condition<?, ?> reconcileCondition, Condition<?, ?> deletePostCondition, Condition<?, ?> activationCondition, String useEventSourceWithName) {
        this.dependentResourceClass = dependentResourceClass;
        this.name = name;
        this.dependsOn = dependsOn;
        this.readyCondition = readyCondition;
        this.reconcileCondition = reconcileCondition;
        this.deletePostCondition = deletePostCondition;
        this.activationCondition = activationCondition;
        this.useEventSourceWithName = useEventSourceWithName;
    }

    public Class<? extends DependentResource<R, P>> getDependentResourceClass() {
        return this.dependentResourceClass;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "DependentResourceSpec{ name='" + this.name + "', type=" + this.getDependentResourceClass().getCanonicalName() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependentResourceSpec that = (DependentResourceSpec)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public Set<String> getDependsOn() {
        return this.dependsOn;
    }

    public Condition getReadyCondition() {
        return this.readyCondition;
    }

    public Condition getReconcileCondition() {
        return this.reconcileCondition;
    }

    public Condition getDeletePostCondition() {
        return this.deletePostCondition;
    }

    public Condition getActivationCondition() {
        return this.activationCondition;
    }

    public Optional<String> getUseEventSourceWithName() {
        return Optional.ofNullable(this.useEventSourceWithName);
    }
}

