/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.NamespaceChangeable;
import io.javaoperatorsdk.operator.api.config.ResourceConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.dependent.RecentOperationCacheFiller;
import io.javaoperatorsdk.operator.health.InformerHealthIndicator;
import io.javaoperatorsdk.operator.health.InformerWrappingEventSourceHealthIndicator;
import io.javaoperatorsdk.operator.health.Status;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.AbstractResourceEventSource;
import io.javaoperatorsdk.operator.processing.event.source.Cache;
import io.javaoperatorsdk.operator.processing.event.source.Configurable;
import io.javaoperatorsdk.operator.processing.event.source.IndexerResourceCache;
import io.javaoperatorsdk.operator.processing.event.source.informer.InformerManager;
import io.javaoperatorsdk.operator.processing.event.source.informer.TemporaryResourceCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManagedInformerEventSource<R extends HasMetadata, P extends HasMetadata, C extends ResourceConfiguration<R>>
extends AbstractResourceEventSource<R, P>
implements ResourceEventHandler<R>,
Cache<R>,
IndexerResourceCache<R>,
RecentOperationCacheFiller<R>,
NamespaceChangeable,
InformerWrappingEventSourceHealthIndicator<R>,
Configurable<C> {
    private static final Logger log = LoggerFactory.getLogger(ManagedInformerEventSource.class);
    private InformerManager<R, C> cache;
    private final boolean parseResourceVersions;
    private ConfigurationService configurationService;
    private final C configuration;
    private Map<String, Function<R, List<String>>> indexers = new HashMap<String, Function<R, List<String>>>();
    protected TemporaryResourceCache<R> temporaryResourceCache;
    protected MixedOperation client;

    protected ManagedInformerEventSource(MixedOperation client, C configuration, boolean parseResourceVersions) {
        super(configuration.getResourceClass());
        this.parseResourceVersions = parseResourceVersions;
        this.client = client;
        this.configuration = configuration;
    }

    public void onAdd(R resource) {
        this.temporaryResourceCache.onEvent(resource, false);
    }

    public void onUpdate(R oldObj, R newObj) {
        this.temporaryResourceCache.onEvent(newObj, false);
    }

    public void onDelete(R obj, boolean deletedFinalStateUnknown) {
        this.temporaryResourceCache.onEvent(obj, deletedFinalStateUnknown);
    }

    protected InformerManager<R, C> manager() {
        return this.cache;
    }

    @Override
    public void changeNamespaces(Set<String> namespaces) {
        if (this.allowsNamespaceChanges()) {
            this.manager().changeNamespaces(namespaces);
        }
    }

    @Override
    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        this.temporaryResourceCache = new TemporaryResourceCache(this, this.parseResourceVersions);
        this.cache = new InformerManager(this.client, this.configuration, this);
        this.cache.setConfigurationService(this.configurationService);
        this.cache.addIndexers(this.indexers);
        this.manager().start();
        super.start();
    }

    @Override
    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        super.stop();
        this.manager().stop();
    }

    @Override
    public void handleRecentResourceUpdate(ResourceID resourceID, R resource, R previousVersionOfResource) {
        this.temporaryResourceCache.putResource(resource, previousVersionOfResource.getMetadata().getResourceVersion());
    }

    @Override
    public void handleRecentResourceCreate(ResourceID resourceID, R resource) {
        this.temporaryResourceCache.putAddedResource(resource);
    }

    @Override
    public Optional<R> get(ResourceID resourceID) {
        Optional<R> resource = this.temporaryResourceCache.getResourceFromCache(resourceID);
        if (resource.isPresent()) {
            log.debug("Resource found in temporary cache for Resource ID: {}", (Object)resourceID);
            return resource;
        }
        log.debug("Resource not found in temporary cache reading it from informer cache, for Resource ID: {}", (Object)resourceID);
        Optional<R> res = this.cache.get(resourceID);
        log.debug("Resource found in cache: {} for id: {}", (Object)res.isPresent(), (Object)resourceID);
        return res;
    }

    public Optional<R> getCachedValue(ResourceID resourceID) {
        return this.get(resourceID);
    }

    @Override
    public Stream<R> list(String namespace, Predicate<R> predicate) {
        return this.manager().list(namespace, predicate);
    }

    void setTemporalResourceCache(TemporaryResourceCache<R> temporaryResourceCache) {
        this.temporaryResourceCache = temporaryResourceCache;
    }

    @Override
    public void addIndexers(Map<String, Function<R, List<String>>> indexers) {
        if (this.isRunning()) {
            throw new OperatorException("Cannot add indexers after InformerEventSource started.");
        }
        this.indexers.putAll(indexers);
    }

    @Override
    public List<R> byIndex(String indexName, String indexKey) {
        return this.manager().byIndex(indexName, indexKey);
    }

    @Override
    public Stream<ResourceID> keys() {
        return this.cache.keys();
    }

    @Override
    public Stream<R> list(Predicate<R> predicate) {
        return this.cache.list(predicate);
    }

    @Override
    public Map<String, InformerHealthIndicator> informerHealthIndicators() {
        return this.cache.informerHealthIndicators();
    }

    @Override
    public Status getStatus() {
        return InformerWrappingEventSourceHealthIndicator.super.getStatus();
    }

    @Override
    public ResourceConfiguration<R> getInformerConfiguration() {
        return this.configuration();
    }

    @Override
    public C configuration() {
        return this.configuration;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{resourceClass: " + this.configuration().getResourceClass().getSimpleName() + "}";
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

