/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.reconciler;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.BaseControl;

public class UpdateControl<P extends HasMetadata>
extends BaseControl<UpdateControl<P>> {
    private final P resource;
    private final boolean updateStatus;
    private final boolean updateResource;
    private final boolean patchStatus;

    private UpdateControl(P resource, boolean updateStatus, boolean updateResource, boolean patchStatus) {
        if ((updateResource || updateStatus) && resource == null) {
            throw new IllegalArgumentException("CustomResource cannot be null in case of update");
        }
        this.resource = resource;
        this.updateStatus = updateStatus;
        this.updateResource = updateResource;
        this.patchStatus = patchStatus;
    }

    public static <T extends HasMetadata> UpdateControl<T> updateResource(T customResource) {
        return new UpdateControl<T>(customResource, false, true, false);
    }

    public static <T extends HasMetadata> UpdateControl<T> patchStatus(T customResource) {
        return new UpdateControl<T>(customResource, true, false, true);
    }

    public static <T extends HasMetadata> UpdateControl<T> updateStatus(T customResource) {
        return new UpdateControl<T>(customResource, true, false, false);
    }

    public static <T extends HasMetadata> UpdateControl<T> updateResourceAndStatus(T customResource) {
        return new UpdateControl<T>(customResource, true, true, false);
    }

    public static <T extends HasMetadata> UpdateControl<T> updateResourceAndPatchStatus(T customResource) {
        return new UpdateControl<T>(customResource, true, true, true);
    }

    @Deprecated(forRemoval=true)
    public static <T extends HasMetadata> UpdateControl<T> patchResourceAndStatus(T customResource) {
        return UpdateControl.updateResourceAndStatus(customResource);
    }

    public static <T extends HasMetadata> UpdateControl<T> noUpdate() {
        return new UpdateControl<Object>(null, false, false, false);
    }

    public P getResource() {
        return this.resource;
    }

    public boolean isUpdateStatus() {
        return this.updateStatus;
    }

    public boolean isUpdateResource() {
        return this.updateResource;
    }

    public boolean isPatchStatus() {
        return this.patchStatus;
    }

    public boolean isNoUpdate() {
        return !this.updateResource && !this.updateStatus;
    }

    public boolean isUpdateResourceAndStatus() {
        return this.updateResource && this.updateStatus;
    }
}

