/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mifmif.common.regex.Generex;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.OperationInfo;
import io.fabric8.kubernetes.client.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.client.ParameterValue;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateOperationsImpl
extends HasMetadataOperation<Template, TemplateList, TemplateResource>
implements TemplateResource,
ParameterMixedOperation<Template, TemplateList, TemplateResource> {
    private static final Logger logger = LoggerFactory.getLogger(TemplateOperationsImpl.class);
    private static final String EXPRESSION = "expression";
    private static final TypeReference<HashMap<String, String>> MAPS_REFERENCE = new TypeReference<HashMap<String, String>>(){};
    private final Map<String, String> parameters;

    public TemplateOperationsImpl(Client client) {
        this(HasMetadataOperationsImpl.defaultContext((Client)client), null);
    }

    public TemplateOperationsImpl(OperationContext context, Map<String, String> parameters) {
        super(context.withApiGroupName("template.openshift.io").withPlural("templates"), Template.class, TemplateList.class);
        this.parameters = parameters;
    }

    public TemplateOperationsImpl newInstance(OperationContext context) {
        return new TemplateOperationsImpl(context, this.parameters);
    }

    public TemplateOperationsImpl newInstance(OperationContext context, Map<String, String> parameters) {
        return new TemplateOperationsImpl(context, (Map<String, String>)(parameters == null ? null : new LinkedHashMap<String, String>(parameters)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KubernetesList process(File f) {
        try (FileInputStream is = new FileInputStream(f);){
            KubernetesList kubernetesList = this.process(is);
            return kubernetesList;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("process"), (Throwable)e);
        }
    }

    public KubernetesList process(InputStream is) {
        return this.process((Map)this.getKubernetesSerialization().unmarshal(is, MAPS_REFERENCE));
    }

    public KubernetesList process(Map<String, String> valuesMap) {
        Template t = this.get();
        try {
            List parameters = t.getParameters();
            if (parameters != null) {
                for (Parameter p : parameters) {
                    String v = valuesMap.get(p.getName());
                    if (v == null) continue;
                    p.setGenerate(null);
                    p.setValue(v);
                }
            }
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", this.getKubernetesSerialization().asJson((Object)t)).url(this.getProcessUrl());
            t = (Template)this.handleResponse(requestBuilder);
            KubernetesList l = new KubernetesList();
            l.setItems(t.getObjects());
            return l;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("process"), (Throwable)e);
        }
    }

    public KubernetesList process(ParameterValue ... values) {
        HashMap<String, String> valuesMap = new HashMap<String, String>(values.length);
        for (ParameterValue pv : values) {
            valuesMap.put(pv.getName(), pv.getValue());
        }
        return this.process(valuesMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KubernetesList processLocally(File f) {
        try (FileInputStream is = new FileInputStream(f);){
            KubernetesList kubernetesList = this.processLocally(is);
            return kubernetesList;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("processLocally"), (Throwable)e);
        }
    }

    public KubernetesList processLocally(InputStream is) {
        return this.processLocally((Map)this.getKubernetesSerialization().unmarshal(is, MAPS_REFERENCE));
    }

    public KubernetesList processLocally(ParameterValue ... values) {
        HashMap<String, String> valuesMap = new HashMap<String, String>(values.length);
        for (ParameterValue pv : values) {
            valuesMap.put(pv.getName(), pv.getValue());
        }
        return this.processLocally(valuesMap);
    }

    public TemplateOperationsImpl withParameters(Map<String, String> parameters) {
        return this.newInstance(this.context, parameters);
    }

    public KubernetesList processLocally(Map<String, String> valuesMap) {
        Template t = this.processParameters((Template)this.getItemOrRequireFromServer());
        List parameters = t.getParameters();
        KubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(t.getObjects())).build();
        String json = this.getKubernetesSerialization().asJson((Object)list);
        String last = null;
        if (parameters != null && !parameters.isEmpty()) {
            while (!Objects.equals(last, json)) {
                last = json;
                for (Parameter parameter : parameters) {
                    String parameterValue;
                    String parameterName = parameter.getName();
                    if (valuesMap.containsKey(parameterName)) {
                        parameterValue = valuesMap.get(parameterName);
                    } else if (Utils.isNotNullOrEmpty((String)parameter.getValue())) {
                        parameterValue = parameter.getValue();
                    } else if (EXPRESSION.equals(parameter.getGenerate())) {
                        Generex generex = new Generex(parameter.getFrom());
                        parameterValue = generex.random();
                    } else if (parameter.getRequired() == null || !parameter.getRequired().booleanValue()) {
                        parameterValue = "";
                    } else {
                        throw new IllegalArgumentException("No value available for parameter name: " + parameterName);
                    }
                    if (parameterValue == null) {
                        logger.debug("Parameter {} has a null value", (Object)parameterName);
                        parameterValue = "";
                    }
                    json = Utils.interpolateString((String)json, Collections.singletonMap(parameterName, parameterValue));
                }
            }
        }
        return (KubernetesList)this.getKubernetesSerialization().unmarshal(json, KubernetesList.class);
    }

    private URL getProcessUrl() throws MalformedURLException {
        return this.getNamespacedUrl(this.getNamespace(), "processedtemplates");
    }

    public Template get() {
        return this.processParameters((Template)super.get());
    }

    private Template processParameters(Template t) {
        if (this.parameters != null && !this.parameters.isEmpty()) {
            return (Template)this.getKubernetesSerialization().unmarshal(Utils.interpolateString((String)this.getKubernetesSerialization().asJson((Object)t), this.parameters), Template.class);
        }
        return t;
    }

    public TemplateResource load(InputStream is) {
        List items;
        Template template = null;
        List item = items = ((KubernetesClient)this.context.getClient().adapt(KubernetesClient.class)).load(is).items();
        if (items.size() == 1) {
            item = items.get(0);
        }
        if (item instanceof Template) {
            template = (Template)item;
        } else {
            String generatedName = "template-" + Utils.randomString((int)5);
            template = ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(generatedName)).endMetadata()).withObjects(items)).build();
        }
        return (TemplateResource)this.resource((HasMetadata)template);
    }
}

