/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceAction;
import java.util.Objects;
import java.util.Optional;

public class ResourceEvent
extends Event {
    private final ResourceAction action;
    private final HasMetadata resource;

    public ResourceEvent(ResourceAction action, ResourceID resourceID, HasMetadata resource) {
        super(resourceID);
        this.action = action;
        this.resource = resource;
    }

    @Override
    public String toString() {
        return "ResourceEvent{action=" + this.action + ", associated resource id=" + this.getRelatedCustomResourceID() + "}";
    }

    public ResourceAction getAction() {
        return this.action;
    }

    public Optional<HasMetadata> getResource() {
        return Optional.ofNullable(this.resource);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceEvent that = (ResourceEvent)o;
        return this.action == that.action;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.action});
    }
}

