/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config.informer;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import io.javaoperatorsdk.operator.api.config.DefaultResourceConfiguration;
import io.javaoperatorsdk.operator.api.config.ResourceConfiguration;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.processing.GroupVersionKind;
import io.javaoperatorsdk.operator.processing.event.source.PrimaryToSecondaryMapper;
import io.javaoperatorsdk.operator.processing.event.source.SecondaryToPrimaryMapper;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnDeleteFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.event.source.informer.Mappers;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public interface InformerConfiguration<R extends HasMetadata>
extends ResourceConfiguration<R> {
    public boolean followControllerNamespaceChanges();

    public SecondaryToPrimaryMapper<R> getSecondaryToPrimaryMapper();

    @Override
    public Optional<OnAddFilter<? super R>> onAddFilter();

    @Override
    public Optional<OnUpdateFilter<? super R>> onUpdateFilter();

    public Optional<OnDeleteFilter<? super R>> onDeleteFilter();

    @Override
    public Optional<GenericFilter<? super R>> genericFilter();

    public <P extends HasMetadata> PrimaryToSecondaryMapper<P> getPrimaryToSecondaryMapper();

    public Optional<GroupVersionKind> getGroupVersionKind();

    public static <R extends HasMetadata> InformerConfigurationBuilder<R> from(Class<R> resourceClass) {
        return new InformerConfigurationBuilder<R>(resourceClass);
    }

    public static <R extends HasMetadata> InformerConfigurationBuilder<R> from(GroupVersionKind groupVersionKind) {
        return new InformerConfigurationBuilder(groupVersionKind);
    }

    public static <R extends HasMetadata> InformerConfigurationBuilder<R> from(Class<R> resourceClass, EventSourceContext<?> eventSourceContext) {
        return new InformerConfigurationBuilder<R>(resourceClass).withNamespacesInheritedFromController(eventSourceContext);
    }

    public static InformerConfigurationBuilder<GenericKubernetesResource> from(GroupVersionKind groupVersionKind, EventSourceContext<?> eventSourceContext) {
        return new InformerConfigurationBuilder(groupVersionKind).withNamespacesInheritedFromController(eventSourceContext);
    }

    @Override
    default public Class<R> getResourceClass() {
        return Utils.getFirstTypeArgumentFromSuperClassOrInterface(this.getClass(), InformerConfiguration.class);
    }

    public static class InformerConfigurationBuilder<R extends HasMetadata> {
        private final Class<R> resourceClass;
        private final GroupVersionKind groupVersionKind;
        private PrimaryToSecondaryMapper<?> primaryToSecondaryMapper;
        private SecondaryToPrimaryMapper<R> secondaryToPrimaryMapper;
        private Set<String> namespaces;
        private String labelSelector;
        private OnAddFilter<? super R> onAddFilter;
        private OnUpdateFilter<? super R> onUpdateFilter;
        private OnDeleteFilter<? super R> onDeleteFilter;
        private GenericFilter<? super R> genericFilter;
        private boolean inheritControllerNamespacesOnChange = false;
        private ItemStore<R> itemStore;
        private Long informerListLimit;

        private InformerConfigurationBuilder(Class<R> resourceClass) {
            this.resourceClass = resourceClass;
            this.groupVersionKind = null;
        }

        private InformerConfigurationBuilder(GroupVersionKind groupVersionKind) {
            this.resourceClass = GenericKubernetesResource.class;
            this.groupVersionKind = groupVersionKind;
        }

        public <P extends HasMetadata> InformerConfigurationBuilder<R> withPrimaryToSecondaryMapper(PrimaryToSecondaryMapper<P> primaryToSecondaryMapper) {
            this.primaryToSecondaryMapper = primaryToSecondaryMapper;
            return this;
        }

        public InformerConfigurationBuilder<R> withSecondaryToPrimaryMapper(SecondaryToPrimaryMapper<R> secondaryToPrimaryMapper) {
            this.secondaryToPrimaryMapper = secondaryToPrimaryMapper;
            return this;
        }

        public InformerConfigurationBuilder<R> withNamespaces(String ... namespaces) {
            return this.withNamespaces(namespaces != null ? Set.of(namespaces) : Constants.DEFAULT_NAMESPACES_SET);
        }

        public InformerConfigurationBuilder<R> withNamespaces(Set<String> namespaces) {
            return this.withNamespaces(namespaces, false);
        }

        public InformerConfigurationBuilder<R> withNamespaces(Set<String> namespaces, boolean followChanges) {
            this.namespaces = namespaces != null ? namespaces : Constants.DEFAULT_NAMESPACES_SET;
            this.inheritControllerNamespacesOnChange = true;
            return this;
        }

        public <P extends HasMetadata> InformerConfigurationBuilder<R> withNamespacesInheritedFromController(EventSourceContext<P> context) {
            this.namespaces = context.getControllerConfiguration().getEffectiveNamespaces();
            this.inheritControllerNamespacesOnChange = true;
            return this;
        }

        public InformerConfigurationBuilder<R> followNamespaceChanges(boolean followChanges) {
            this.inheritControllerNamespacesOnChange = followChanges;
            return this;
        }

        public InformerConfigurationBuilder<R> withLabelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public InformerConfigurationBuilder<R> withOnAddFilter(OnAddFilter<? super R> onAddFilter) {
            this.onAddFilter = onAddFilter;
            return this;
        }

        public InformerConfigurationBuilder<R> withOnUpdateFilter(OnUpdateFilter<? super R> onUpdateFilter) {
            this.onUpdateFilter = onUpdateFilter;
            return this;
        }

        public InformerConfigurationBuilder<R> withOnDeleteFilter(OnDeleteFilter<? super R> onDeleteFilter) {
            this.onDeleteFilter = onDeleteFilter;
            return this;
        }

        public InformerConfigurationBuilder<R> withGenericFilter(GenericFilter<? super R> genericFilter) {
            this.genericFilter = genericFilter;
            return this;
        }

        public InformerConfigurationBuilder<R> withItemStore(ItemStore<R> itemStore) {
            this.itemStore = itemStore;
            return this;
        }

        public InformerConfigurationBuilder<R> withInformerListLimit(Long informerListLimit) {
            this.informerListLimit = informerListLimit;
            return this;
        }

        public InformerConfiguration<R> build() {
            return new DefaultInformerConfiguration<R>(this.labelSelector, this.resourceClass, this.groupVersionKind, this.primaryToSecondaryMapper, this.secondaryToPrimaryMapper, this.namespaces, this.inheritControllerNamespacesOnChange, this.onAddFilter, this.onUpdateFilter, this.onDeleteFilter, this.genericFilter, this.itemStore, this.informerListLimit);
        }
    }

    public static class DefaultInformerConfiguration<R extends HasMetadata>
    extends DefaultResourceConfiguration<R>
    implements InformerConfiguration<R> {
        private final PrimaryToSecondaryMapper<?> primaryToSecondaryMapper;
        private final SecondaryToPrimaryMapper<R> secondaryToPrimaryMapper;
        private final boolean followControllerNamespaceChanges;
        private final OnDeleteFilter<? super R> onDeleteFilter;
        private final GroupVersionKind groupVersionKind;

        protected DefaultInformerConfiguration(String labelSelector, Class<R> resourceClass, GroupVersionKind groupVersionKind, PrimaryToSecondaryMapper<?> primaryToSecondaryMapper, SecondaryToPrimaryMapper<R> secondaryToPrimaryMapper, Set<String> namespaces, boolean followControllerNamespaceChanges, OnAddFilter<? super R> onAddFilter, OnUpdateFilter<? super R> onUpdateFilter, OnDeleteFilter<? super R> onDeleteFilter, GenericFilter<? super R> genericFilter, ItemStore<R> itemStore, Long informerListLimit) {
            super(resourceClass, namespaces, labelSelector, onAddFilter, onUpdateFilter, genericFilter, itemStore, informerListLimit);
            this.followControllerNamespaceChanges = followControllerNamespaceChanges;
            this.groupVersionKind = groupVersionKind;
            this.primaryToSecondaryMapper = primaryToSecondaryMapper;
            this.secondaryToPrimaryMapper = Objects.requireNonNullElse(secondaryToPrimaryMapper, Mappers.fromOwnerReference());
            this.onDeleteFilter = onDeleteFilter;
        }

        @Override
        public boolean followControllerNamespaceChanges() {
            return this.followControllerNamespaceChanges;
        }

        @Override
        public SecondaryToPrimaryMapper<R> getSecondaryToPrimaryMapper() {
            return this.secondaryToPrimaryMapper;
        }

        @Override
        public Optional<OnDeleteFilter<? super R>> onDeleteFilter() {
            return Optional.ofNullable(this.onDeleteFilter);
        }

        @Override
        public <P extends HasMetadata> PrimaryToSecondaryMapper<P> getPrimaryToSecondaryMapper() {
            return this.primaryToSecondaryMapper;
        }

        @Override
        public Optional<GroupVersionKind> getGroupVersionKind() {
            return Optional.ofNullable(this.groupVersionKind);
        }
    }
}

