/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.docs.output;

import io.debezium.operator.docs.model.Documentation;
import io.debezium.operator.docs.output.DocumentationFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AsciidocFormatter
implements DocumentationFormatter {
    private Map<String, Set<String>> index = new HashMap<String, Set<String>>();

    private String identifier(String ... names) {
        return Stream.of(names).map(String::toLowerCase).map(name -> name.replace(" ", "-")).collect(Collectors.joining("-"));
    }

    private String formatDocHeader(Documentation documentation) {
        String template = "[#%s]\n=== %s\n\n";
        return template.formatted(this.identifier(documentation.title()), documentation.title());
    }

    private String formatType(Documentation documentation, Documentation.TypeDescription type) {
        String template = "[#%s]\n==== %s Schema Reference\n%s\n\n.%s properties\n[cols=\"20%%a,25%%s,15%%a,40%%a\",options=\"header\"]\n|===\n| Property | Type | Default | Description\n%s\n|===\n\n";
        return template.formatted(this.identifier(documentation.title(), type.name()), type.name(), this.formatUsageReference(documentation, type), type.name(), this.formatFields(documentation, type));
    }

    private String formatUsageReference(Documentation documentation, Documentation.TypeDescription type) {
        String template = "Used in: %s\n";
        String usages = documentation.getUsages(type.name()).stream().sorted().map(name -> this.formatTypeReference(documentation, (String)name, (String)name)).collect(Collectors.joining(", "));
        if (usages.isEmpty()) {
            return "";
        }
        return template.formatted(usages);
    }

    private String formatField(Documentation documentation, Documentation.TypeDescription type, Documentation.FieldDescription field) {
        String template = "| %s | %s | %s | %s";
        return template.formatted(this.formatFieldName(documentation, type, field), this.formatFieldType(documentation, type, field), field.defaultValue(), field.description());
    }

    private String formatFieldName(Documentation documentation, Documentation.TypeDescription type, Documentation.FieldDescription field) {
        String template = "[[%s]]<<%s, `+%s+`>>";
        return template.formatted(this.identifier(documentation.title(), type.name(), field.name()), this.identifier(documentation.title(), type.name(), field.name()), field.name());
    }

    private String formatTypeReference(Documentation documentation, String type, String typeRef) {
        String template = "<<%s, `+%s+`>>";
        return template.formatted(this.identifier(documentation.title(), typeRef), type);
    }

    private String formatFieldType(Documentation documentation, Documentation.TypeDescription type, Documentation.FieldDescription field) {
        if (field.typeRef() != null) {
            return this.formatTypeReference(documentation, field.type(), field.typeRef());
        }
        if (field.externalTypeRef() != null) {
            String template = "%s[`+%s+`]";
            return template.formatted(field.externalTypeRef(), field.type());
        }
        return field.type();
    }

    private String formatFields(Documentation documentation, Documentation.TypeDescription type) {
        return type.fields().stream().map(f -> this.formatField(documentation, type, (Documentation.FieldDescription)f)).collect(Collectors.joining("\n"));
    }

    @Override
    public String formatted(Documentation documentation) {
        StringBuilder docs = new StringBuilder();
        docs.append(this.formatDocHeader(documentation));
        documentation.types().stream().sorted(Comparator.comparing(Documentation.TypeDescription::name)).map(t -> this.formatType(documentation, (Documentation.TypeDescription)t)).forEach(docs::append);
        return docs.toString();
    }
}

