/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.dependent.Configured;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.Ignore;
import io.javaoperatorsdk.operator.api.reconciler.ResourceDiscriminator;
import io.javaoperatorsdk.operator.api.reconciler.dependent.GarbageCollected;
import io.javaoperatorsdk.operator.api.reconciler.dependent.managed.DependentResourceConfigurator;
import io.javaoperatorsdk.operator.processing.dependent.AbstractEventSourceHolderDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.Matcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentConverter;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfig;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.ResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.SSABasedGenericKubernetesResourceMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher.GenericResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.SecondaryToPrimaryMapper;
import io.javaoperatorsdk.operator.processing.event.source.informer.InformerEventSource;
import io.javaoperatorsdk.operator.processing.event.source.informer.Mappers;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
@Configured(by=KubernetesDependent.class, with=KubernetesDependentResourceConfig.class, converter=KubernetesDependentConverter.class)
public abstract class KubernetesDependentResource<R extends HasMetadata, P extends HasMetadata>
extends AbstractEventSourceHolderDependentResource<R, P, InformerEventSource<R, P>>
implements DependentResourceConfigurator<KubernetesDependentResourceConfig<R>> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesDependentResource.class);
    private final ResourceUpdaterMatcher<R> updaterMatcher;
    private final boolean garbageCollected = this instanceof GarbageCollected;
    private KubernetesDependentResourceConfig<R> kubernetesDependentResourceConfig;
    private final boolean usingCustomResourceUpdateMatcher = this instanceof ResourceUpdaterMatcher;

    public KubernetesDependentResource(Class<R> resourceType) {
        super(resourceType);
        this.updaterMatcher = this.usingCustomResourceUpdateMatcher ? (ResourceUpdaterMatcher<R>)((Object)this) : GenericResourceUpdaterMatcher.updaterMatcherFor(resourceType);
    }

    @Override
    public void configureWith(KubernetesDependentResourceConfig<R> config) {
        this.kubernetesDependentResourceConfig = config;
        ResourceDiscriminator discriminator = this.kubernetesDependentResourceConfig.getResourceDiscriminator();
        if (discriminator != null) {
            this.setResourceDiscriminator(discriminator);
        }
    }

    private void configureWith(String labelSelector, Set<String> namespaces, boolean inheritNamespacesOnChange, EventSourceContext<P> context) {
        if (namespaces.equals(Constants.SAME_AS_CONTROLLER_NAMESPACES_SET)) {
            namespaces = context.getControllerConfiguration().getNamespaces();
        }
        InformerConfiguration ic = InformerConfiguration.from(this.resourceType()).withLabelSelector(labelSelector).withSecondaryToPrimaryMapper(this.getSecondaryToPrimaryMapper()).withNamespaces(namespaces, inheritNamespacesOnChange).build();
        this.configureWith(new InformerEventSource(ic, context));
    }

    private SecondaryToPrimaryMapper<R> getSecondaryToPrimaryMapper() {
        if (this instanceof SecondaryToPrimaryMapper) {
            return (SecondaryToPrimaryMapper)((Object)this);
        }
        if (this.garbageCollected) {
            return Mappers.fromOwnerReference();
        }
        if (this.useNonOwnerRefBasedSecondaryToPrimaryMapping()) {
            return Mappers.fromDefaultAnnotations();
        }
        throw new OperatorException("Provide a SecondaryToPrimaryMapper to associate this resource with the primary resource. DependentResource: " + this.getClass().getName());
    }

    @Override
    public void configureWith(InformerEventSource<R, P> informerEventSource) {
        this.setEventSource(informerEventSource);
    }

    public R create(R desired, P primary, Context<P> context) {
        if (this.useSSA(context)) {
            boolean createIfNotExisting;
            boolean bl = createIfNotExisting = this.kubernetesDependentResourceConfig == null ? true : this.kubernetesDependentResourceConfig.createResourceOnlyIfNotExistingWithSSA();
            if (createIfNotExisting) {
                desired.getMetadata().setResourceVersion("1");
            }
        }
        this.addMetadata(false, null, desired, primary, context);
        Resource<R> resource = this.prepare(context, desired, primary, "Creating");
        return (R)(this.useSSA(context) ? (HasMetadata)resource.fieldManager(context.getControllerConfiguration().fieldManager()).forceConflicts().serverSideApply() : (HasMetadata)resource.create());
    }

    public R update(R actual, R desired, P primary, Context<P> context) {
        HasMetadata updatedResource;
        if (log.isDebugEnabled()) {
            log.debug("Updating actual resource: {} version: {}", (Object)ResourceID.fromResource(actual), (Object)actual.getMetadata().getResourceVersion());
        }
        this.addMetadata(false, actual, desired, primary, context);
        if (this.useSSA(context)) {
            updatedResource = (HasMetadata)this.prepare(context, desired, primary, "Updating").fieldManager(context.getControllerConfiguration().fieldManager()).forceConflicts().serverSideApply();
        } else {
            R updatedActual = this.updaterMatcher.updateResource(actual, desired, context);
            updatedResource = (HasMetadata)this.prepare(context, updatedActual, primary, "Updating").update();
        }
        log.debug("Resource version after update: {}", (Object)updatedResource.getMetadata().getResourceVersion());
        return (R)updatedResource;
    }

    @Override
    public Matcher.Result<R> match(R actualResource, P primary, Context<P> context) {
        R desired = this.desired(primary, context);
        return this.match(actualResource, desired, primary, this.updaterMatcher, context);
    }

    public Matcher.Result<R> match(R actualResource, R desired, P primary, Context<P> context) {
        return this.match(actualResource, desired, primary, GenericResourceUpdaterMatcher.updaterMatcherFor(actualResource.getClass()), context);
    }

    public Matcher.Result<R> match(R actualResource, R desired, P primary, ResourceUpdaterMatcher<R> matcher, Context<P> context) {
        this.addMetadata(true, actualResource, desired, primary, context);
        boolean matches = this.useSSA(context) ? SSABasedGenericKubernetesResourceMatcher.getInstance().matches(actualResource, desired, context) : matcher.matches(actualResource, desired, context);
        return Matcher.Result.computed(matches, desired);
    }

    protected void addMetadata(boolean forMatch, R actualResource, R target, P primary, Context<P> context) {
        if (forMatch) {
            String actual = (String)actualResource.getMetadata().getAnnotations().get(InformerEventSource.PREVIOUS_ANNOTATION_KEY);
            Map annotations = target.getMetadata().getAnnotations();
            if (actual != null) {
                annotations.put(InformerEventSource.PREVIOUS_ANNOTATION_KEY, actual);
            } else {
                annotations.remove(InformerEventSource.PREVIOUS_ANNOTATION_KEY);
            }
        } else if (this.usePreviousAnnotation(context)) {
            ((InformerEventSource)this.eventSource().orElseThrow()).addPreviousAnnotation(Optional.ofNullable(actualResource).map(r -> r.getMetadata().getResourceVersion()).orElse(null), target);
        }
        this.addReferenceHandlingMetadata(target, primary);
    }

    protected boolean useSSA(Context<P> context) {
        if (this.usingCustomResourceUpdateMatcher) {
            return false;
        }
        Optional useSSAConfig = this.configuration().flatMap(KubernetesDependentResourceConfig::useSSA);
        ConfigurationService configService = context.getControllerConfiguration().getConfigurationService();
        if (useSSAConfig.isEmpty() && configService.defaultNonSSAResource().contains(this.resourceType())) {
            return false;
        }
        return useSSAConfig.orElse(context.getControllerConfiguration().getConfigurationService().ssaBasedCreateUpdateMatchForDependentResources());
    }

    private boolean usePreviousAnnotation(Context<P> context) {
        return context.getControllerConfiguration().getConfigurationService().previousAnnotationForDependentResourcesEventFiltering();
    }

    @Override
    protected void handleDelete(P primary, R secondary, Context<P> context) {
        if (secondary != null) {
            context.getClient().resource(secondary).delete();
        }
    }

    public void deleteTargetResource(P primary, R resource, String key, Context<P> context) {
        context.getClient().resource(resource).delete();
    }

    protected Resource<R> prepare(Context<P> context, R desired, P primary, String actionName) {
        log.debug("{} target resource with type: {}, with id: {}", new Object[]{actionName, desired.getClass(), ResourceID.fromResource(desired)});
        return context.getClient().resource(desired);
    }

    protected void addReferenceHandlingMetadata(R desired, P primary) {
        if (this.addOwnerReference()) {
            desired.addOwnerReference(primary);
        } else if (this.useNonOwnerRefBasedSecondaryToPrimaryMapping()) {
            this.addSecondaryToPrimaryMapperAnnotations(desired, primary);
        }
    }

    @Override
    protected InformerEventSource<R, P> createEventSource(EventSourceContext<P> context) {
        if (this.kubernetesDependentResourceConfig != null) {
            this.onAddFilter = this.kubernetesDependentResourceConfig.onAddFilter();
            this.onUpdateFilter = this.kubernetesDependentResourceConfig.onUpdateFilter();
            this.onDeleteFilter = this.kubernetesDependentResourceConfig.onDeleteFilter();
            this.genericFilter = this.kubernetesDependentResourceConfig.genericFilter();
            ResourceDiscriminator discriminator = this.kubernetesDependentResourceConfig.getResourceDiscriminator();
            if (discriminator != null) {
                this.setResourceDiscriminator(discriminator);
            }
            this.configureWith(this.kubernetesDependentResourceConfig.labelSelector(), this.kubernetesDependentResourceConfig.namespaces(), !this.kubernetesDependentResourceConfig.wereNamespacesConfigured(), context);
        } else {
            this.configureWith(null, context.getControllerConfiguration().getNamespaces(), true, context);
            log.warn("Using default configuration for {} KubernetesDependentResource, call configureWith to provide configuration", (Object)this.resourceType().getSimpleName());
        }
        return (InformerEventSource)this.eventSource().orElseThrow();
    }

    private boolean useNonOwnerRefBasedSecondaryToPrimaryMapping() {
        return !this.garbageCollected && this.isCreatable();
    }

    protected void addSecondaryToPrimaryMapperAnnotations(R desired, P primary) {
        this.addSecondaryToPrimaryMapperAnnotations(desired, primary, "io.javaoperatorsdk/primary-name", "io.javaoperatorsdk/primary-namespace");
    }

    protected void addSecondaryToPrimaryMapperAnnotations(R desired, P primary, String nameKey, String namespaceKey) {
        Map annotations = desired.getMetadata().getAnnotations();
        annotations.put(nameKey, primary.getMetadata().getName());
        String primaryNamespaces = primary.getMetadata().getNamespace();
        if (primaryNamespaces != null) {
            annotations.put(namespaceKey, primary.getMetadata().getNamespace());
        }
    }

    protected boolean addOwnerReference() {
        return this.garbageCollected;
    }

    @Override
    protected R desired(P primary, Context<P> context) {
        return (R)((HasMetadata)super.desired(primary, context));
    }

    @Override
    public Optional<KubernetesDependentResourceConfig<R>> configuration() {
        return Optional.ofNullable(this.kubernetesDependentResourceConfig);
    }

    @Override
    public boolean isDeletable() {
        return super.isDeletable() && !this.garbageCollected;
    }
}

