/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.dependent.Configured;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.Ignore;
import io.javaoperatorsdk.operator.api.reconciler.ResourceDiscriminator;
import io.javaoperatorsdk.operator.api.reconciler.dependent.GarbageCollected;
import io.javaoperatorsdk.operator.api.reconciler.dependent.managed.DependentResourceConfigurator;
import io.javaoperatorsdk.operator.api.reconciler.dependent.managed.KubernetesClientAware;
import io.javaoperatorsdk.operator.processing.dependent.AbstractEventSourceHolderDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.Matcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.GenericKubernetesResourceMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentConverter;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfig;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.ResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.SSABasedGenericKubernetesResourceMatcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.updatermatcher.GenericResourceUpdaterMatcher;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.SecondaryToPrimaryMapper;
import io.javaoperatorsdk.operator.processing.event.source.informer.InformerEventSource;
import io.javaoperatorsdk.operator.processing.event.source.informer.Mappers;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
@Configured(by=KubernetesDependent.class, with=KubernetesDependentResourceConfig.class, converter=KubernetesDependentConverter.class)
public abstract class KubernetesDependentResource<R extends HasMetadata, P extends HasMetadata>
extends AbstractEventSourceHolderDependentResource<R, P, InformerEventSource<R, P>>
implements KubernetesClientAware,
DependentResourceConfigurator<KubernetesDependentResourceConfig<R>> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesDependentResource.class);
    protected KubernetesClient client;
    private final ResourceUpdaterMatcher<R> updaterMatcher;
    private final boolean garbageCollected = this instanceof GarbageCollected;
    private KubernetesDependentResourceConfig<R> kubernetesDependentResourceConfig;

    public KubernetesDependentResource(Class<R> resourceType) {
        super(resourceType);
        this.updaterMatcher = this instanceof ResourceUpdaterMatcher ? (ResourceUpdaterMatcher<R>)((Object)this) : GenericResourceUpdaterMatcher.updaterMatcherFor(resourceType);
    }

    @Override
    public void configureWith(KubernetesDependentResourceConfig<R> config) {
        this.kubernetesDependentResourceConfig = config;
        ResourceDiscriminator discriminator = this.kubernetesDependentResourceConfig.getResourceDiscriminator();
        if (discriminator != null) {
            this.setResourceDiscriminator(discriminator);
        }
    }

    private void configureWith(String labelSelector, Set<String> namespaces, boolean inheritNamespacesOnChange, EventSourceContext<P> context) {
        if (namespaces.equals(Constants.SAME_AS_CONTROLLER_NAMESPACES_SET)) {
            namespaces = context.getControllerConfiguration().getNamespaces();
        }
        InformerConfiguration ic = InformerConfiguration.from(this.resourceType()).withLabelSelector(labelSelector).withSecondaryToPrimaryMapper(this.getSecondaryToPrimaryMapper()).withNamespaces(namespaces, inheritNamespacesOnChange).build();
        this.configureWith(new InformerEventSource(ic, context));
    }

    private SecondaryToPrimaryMapper<R> getSecondaryToPrimaryMapper() {
        if (this instanceof SecondaryToPrimaryMapper) {
            return (SecondaryToPrimaryMapper)((Object)this);
        }
        if (this.garbageCollected) {
            return Mappers.fromOwnerReference();
        }
        if (this.useDefaultAnnotationsToIdentifyPrimary()) {
            return Mappers.fromDefaultAnnotations();
        }
        throw new OperatorException("Provide a SecondaryToPrimaryMapper to associate this resource with the primary resource. DependentResource: " + this.getClass().getName());
    }

    @Override
    public void configureWith(InformerEventSource<R, P> informerEventSource) {
        this.setEventSource(informerEventSource);
    }

    @Override
    protected R handleCreate(R desired, P primary, Context<P> context) {
        ResourceID resourceID = ResourceID.fromResource(desired);
        try {
            this.prepareEventFiltering(desired, resourceID);
            return (R)((HasMetadata)super.handleCreate(desired, primary, context));
        }
        catch (RuntimeException e) {
            this.cleanupAfterEventFiltering(resourceID);
            throw e;
        }
    }

    @Override
    protected R handleUpdate(R actual, R desired, P primary, Context<P> context) {
        ResourceID resourceID = ResourceID.fromResource(desired);
        try {
            this.prepareEventFiltering(desired, resourceID);
            return (R)((HasMetadata)super.handleUpdate(actual, desired, primary, context));
        }
        catch (RuntimeException e) {
            this.cleanupAfterEventFiltering(resourceID);
            throw e;
        }
    }

    public R create(R target, P primary, Context<P> context) {
        if (this.useSSA(context)) {
            target.getMetadata().setResourceVersion("1");
        }
        Resource<R> resource = this.prepare(target, primary, "Creating");
        return (R)(this.useSSA(context) ? (HasMetadata)resource.fieldManager(context.getControllerConfiguration().fieldManager()).forceConflicts().serverSideApply() : (HasMetadata)resource.create());
    }

    public R update(R actual, R target, P primary, Context<P> context) {
        HasMetadata updatedResource;
        if (log.isDebugEnabled()) {
            log.debug("Updating actual resource: {} version: {}", (Object)ResourceID.fromResource(actual), (Object)actual.getMetadata().getResourceVersion());
        }
        if (this.useSSA(context)) {
            updatedResource = (HasMetadata)this.prepare(target, primary, "Updating").fieldManager(context.getControllerConfiguration().fieldManager()).forceConflicts().serverSideApply();
        } else {
            R updatedActual = this.updaterMatcher.updateResource(actual, target, context);
            updatedResource = (HasMetadata)this.prepare(updatedActual, primary, "Updating").update();
        }
        log.debug("Resource version after update: {}", (Object)updatedResource.getMetadata().getResourceVersion());
        return (R)updatedResource;
    }

    @Override
    public Matcher.Result<R> match(R actualResource, P primary, Context<P> context) {
        boolean matches;
        R desired = this.desired(primary, context);
        if (this.useSSA(context)) {
            this.addReferenceHandlingMetadata(desired, primary);
            matches = SSABasedGenericKubernetesResourceMatcher.getInstance().matches(actualResource, desired, context);
        } else {
            matches = this.updaterMatcher.matches(actualResource, desired, context);
        }
        return Matcher.Result.computed(matches, desired);
    }

    public Matcher.Result<R> match(R actualResource, R desired, P primary, Context<P> context) {
        if (this.useSSA(context)) {
            this.addReferenceHandlingMetadata(desired, primary);
            boolean matches = SSABasedGenericKubernetesResourceMatcher.getInstance().matches(actualResource, desired, context);
            return Matcher.Result.computed(matches, desired);
        }
        return GenericKubernetesResourceMatcher.match(desired, actualResource, true, false, false, context);
    }

    private boolean useSSA(Context<P> context) {
        return context.getControllerConfiguration().getConfigurationService().ssaBasedCreateUpdateMatchForDependentResources();
    }

    @Override
    protected void handleDelete(P primary, R secondary, Context<P> context) {
        if (secondary != null) {
            this.client.resource(secondary).delete();
        }
    }

    public void deleteTargetResource(P primary, R resource, String key, Context<P> context) {
        this.client.resource(resource).delete();
    }

    protected Resource<R> prepare(R desired, P primary, String actionName) {
        log.debug("{} target resource with type: {}, with id: {}", new Object[]{actionName, desired.getClass(), ResourceID.fromResource(desired)});
        this.addReferenceHandlingMetadata(desired, primary);
        if (desired instanceof Namespaced) {
            return this.client.resource(desired).inNamespace(desired.getMetadata().getNamespace());
        }
        return this.client.resource(desired);
    }

    protected void addReferenceHandlingMetadata(R desired, P primary) {
        if (this.addOwnerReference()) {
            desired.addOwnerReference(primary);
        } else if (this.useDefaultAnnotationsToIdentifyPrimary()) {
            this.addDefaultSecondaryToPrimaryMapperAnnotations(desired, primary);
        }
    }

    @Override
    protected InformerEventSource<R, P> createEventSource(EventSourceContext<P> context) {
        if (this.kubernetesDependentResourceConfig != null) {
            this.onAddFilter = this.kubernetesDependentResourceConfig.onAddFilter();
            this.onUpdateFilter = this.kubernetesDependentResourceConfig.onUpdateFilter();
            this.onDeleteFilter = this.kubernetesDependentResourceConfig.onDeleteFilter();
            this.genericFilter = this.kubernetesDependentResourceConfig.genericFilter();
            ResourceDiscriminator discriminator = this.kubernetesDependentResourceConfig.getResourceDiscriminator();
            if (discriminator != null) {
                this.setResourceDiscriminator(discriminator);
            }
            this.configureWith(this.kubernetesDependentResourceConfig.labelSelector(), this.kubernetesDependentResourceConfig.namespaces(), !this.kubernetesDependentResourceConfig.wereNamespacesConfigured(), context);
        } else {
            this.configureWith(null, context.getControllerConfiguration().getNamespaces(), true, context);
            log.warn("Using default configuration for {} KubernetesDependentResource, call configureWith to provide configuration", (Object)this.resourceType().getSimpleName());
        }
        return (InformerEventSource)this.eventSource().orElseThrow();
    }

    private boolean useDefaultAnnotationsToIdentifyPrimary() {
        return !(this instanceof SecondaryToPrimaryMapper) && !this.garbageCollected && this.isCreatable();
    }

    private void addDefaultSecondaryToPrimaryMapperAnnotations(R desired, P primary) {
        HashMap<String, String> annotations = desired.getMetadata().getAnnotations();
        if (annotations == null) {
            annotations = new HashMap<String, String>();
            desired.getMetadata().setAnnotations(annotations);
        }
        annotations.put("io.javaoperatorsdk/primary-name", primary.getMetadata().getName());
        String primaryNamespaces = primary.getMetadata().getNamespace();
        if (primaryNamespaces != null) {
            annotations.put("io.javaoperatorsdk/primary-namespace", primary.getMetadata().getNamespace());
        }
    }

    protected boolean addOwnerReference() {
        return this.garbageCollected;
    }

    @Override
    public void setKubernetesClient(KubernetesClient kubernetesClient) {
        this.client = kubernetesClient;
    }

    @Override
    public KubernetesClient getKubernetesClient() {
        return this.client;
    }

    @Override
    protected R desired(P primary, Context<P> context) {
        return (R)((HasMetadata)super.desired(primary, context));
    }

    private void prepareEventFiltering(R desired, ResourceID resourceID) {
        ((InformerEventSource)this.eventSource().orElseThrow()).prepareForCreateOrUpdateEventFiltering(resourceID, desired);
    }

    private void cleanupAfterEventFiltering(ResourceID resourceID) {
        ((InformerEventSource)this.eventSource().orElseThrow()).cleanupOnCreateOrUpdateEventFiltering(resourceID);
    }

    @Override
    public Optional<KubernetesDependentResourceConfig<R>> configuration() {
        return Optional.ofNullable(this.kubernetesDependentResourceConfig);
    }

    @Override
    public boolean isDeletable() {
        return super.isDeletable() && !this.garbageCollected;
    }
}

