/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.fabric8.zjsonpatch.JsonDiff;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.Matcher;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GenericKubernetesResourceMatcher<R extends HasMetadata, P extends HasMetadata>
implements Matcher<R, P> {
    private static final String SPEC = "/spec";
    private static final String ADD = "add";
    private static final String OP = "op";
    public static final String METADATA_LABELS = "/metadata/labels";
    public static final String METADATA_ANNOTATIONS = "/metadata/annotations";
    private static final String PATH = "path";
    private static final String[] EMPTY_ARRAY = new String[0];
    private final KubernetesDependentResource<R, P> dependentResource;

    private GenericKubernetesResourceMatcher(KubernetesDependentResource<R, P> dependentResource) {
        this.dependentResource = dependentResource;
    }

    static <R extends HasMetadata, P extends HasMetadata> Matcher<R, P> matcherFor(KubernetesDependentResource<R, P> dependentResource) {
        return new GenericKubernetesResourceMatcher<R, P>(dependentResource);
    }

    @Override
    public Matcher.Result<R> match(R actualResource, P primary, Context<P> context) {
        R desired = this.dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, false, false, false, context);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(R desired, R actualResource, boolean considerLabelsAndAnnotations, boolean labelsAndAnnotationsEquality, boolean specEquality, Context<P> context) {
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, labelsAndAnnotationsEquality, specEquality, context, EMPTY_ARRAY);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(R desired, R actualResource, boolean considerLabelsAndAnnotations, boolean labelsAndAnnotationsEquality, Context<P> context, String ... ignorePaths) {
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, labelsAndAnnotationsEquality, false, context, ignorePaths);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(KubernetesDependentResource<R, P> dependentResource, R actualResource, P primary, Context<P> context, boolean considerLabelsAndAnnotations, boolean labelsAndAnnotationsEquality, String ... ignorePaths) {
        R desired = dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, labelsAndAnnotationsEquality, context, ignorePaths);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(KubernetesDependentResource<R, P> dependentResource, R actualResource, P primary, Context<P> context, boolean considerLabelsAndAnnotations, boolean labelsAndAnnotationsEquality, boolean specEquality) {
        R desired = dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, labelsAndAnnotationsEquality, specEquality, context);
    }

    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(R desired, R actualResource, boolean considerMetadata, boolean labelsAndAnnotationsEquality, boolean specEquality, Context<P> context, String ... ignoredPaths) {
        Optional<Matcher.Result<R>> res;
        List<String> ignoreList;
        List<String> list = ignoreList = ignoredPaths != null && ignoredPaths.length > 0 ? Arrays.asList(ignoredPaths) : Collections.emptyList();
        if (specEquality && !ignoreList.isEmpty()) {
            throw new IllegalArgumentException("Equality should be false in case of ignore list provided");
        }
        if (considerMetadata && (res = GenericKubernetesResourceMatcher.matchMetadata(desired, actualResource, labelsAndAnnotationsEquality, context)).isPresent()) {
            return res.orElseThrow();
        }
        boolean matched = GenericKubernetesResourceMatcher.matchSpec(actualResource, desired, specEquality, context, ignoreList);
        return Matcher.Result.computed(matched, desired);
    }

    private static <R extends HasMetadata> boolean matchSpec(R actual, R desired, boolean equality, Context<?> context, List<String> ignoreList) {
        KubernetesSerialization kubernetesSerialization = context.getClient().getKubernetesSerialization();
        JsonNode desiredNode = (JsonNode)kubernetesSerialization.convertValue(desired, JsonNode.class);
        JsonNode actualNode = (JsonNode)kubernetesSerialization.convertValue(actual, JsonNode.class);
        JsonNode wholeDiffJsonPatch = JsonDiff.asJson((JsonNode)desiredNode, (JsonNode)actualNode);
        List<JsonNode> specDiffJsonPatch = GenericKubernetesResourceMatcher.getDiffsImpactingPathsWithPrefixes(wholeDiffJsonPatch, SPEC);
        if (equality && !specDiffJsonPatch.isEmpty()) {
            return false;
        }
        if (!equality && !ignoreList.isEmpty()) {
            return GenericKubernetesResourceMatcher.allDiffsOnIgnoreList(specDiffJsonPatch, ignoreList);
        }
        return GenericKubernetesResourceMatcher.allDiffsAreAddOps(specDiffJsonPatch);
    }

    private static boolean allDiffsOnIgnoreList(List<JsonNode> metadataJSonDiffs, List<String> ignoreList) {
        if (metadataJSonDiffs.isEmpty()) {
            return false;
        }
        return metadataJSonDiffs.stream().allMatch(n -> GenericKubernetesResourceMatcher.nodeIsChildOf(n, ignoreList));
    }

    private static <R extends HasMetadata, P extends HasMetadata> Optional<Matcher.Result<R>> matchMetadata(R desired, R actualResource, boolean labelsAndAnnotationsEquality, Context<P> context) {
        if (labelsAndAnnotationsEquality) {
            boolean matched;
            ObjectMeta desiredMetadata = desired.getMetadata();
            ObjectMeta actualMetadata = actualResource.getMetadata();
            boolean bl = matched = Objects.equals(desiredMetadata.getAnnotations(), actualMetadata.getAnnotations()) && Objects.equals(desiredMetadata.getLabels(), actualMetadata.getLabels());
            if (!matched) {
                return Optional.of(Matcher.Result.computed(false, desired));
            }
        } else {
            JsonNode actualNode;
            KubernetesSerialization objectMapper = context.getClient().getKubernetesSerialization();
            JsonNode desiredNode = (JsonNode)objectMapper.convertValue(desired, JsonNode.class);
            JsonNode wholeDiffJsonPatch = JsonDiff.asJson((JsonNode)desiredNode, (JsonNode)(actualNode = (JsonNode)objectMapper.convertValue(actualResource, JsonNode.class)));
            List<JsonNode> metadataJSonDiffs = GenericKubernetesResourceMatcher.getDiffsImpactingPathsWithPrefixes(wholeDiffJsonPatch, METADATA_LABELS, METADATA_ANNOTATIONS);
            if (!GenericKubernetesResourceMatcher.allDiffsAreAddOps(metadataJSonDiffs)) {
                return Optional.of(Matcher.Result.computed(false, desired));
            }
        }
        return Optional.empty();
    }

    static boolean nodeIsChildOf(JsonNode n, List<String> prefixes) {
        String path = GenericKubernetesResourceMatcher.getPath(n);
        return prefixes.stream().anyMatch(path::startsWith);
    }

    static String getPath(JsonNode n) {
        return n.get(PATH).asText();
    }

    static boolean allDiffsAreAddOps(List<JsonNode> metadataJSonDiffs) {
        if (metadataJSonDiffs.isEmpty()) {
            return true;
        }
        return metadataJSonDiffs.stream().allMatch(n -> ADD.equals(n.get(OP).asText()));
    }

    public static List<JsonNode> getDiffsImpactingPathsWithPrefixes(JsonNode diffJsonPatch, String ... prefixes) {
        if (prefixes != null && prefixes.length > 0) {
            ArrayList<JsonNode> res = new ArrayList<JsonNode>();
            List<String> prefixList = Arrays.asList(prefixes);
            for (int i = 0; i < diffJsonPatch.size(); ++i) {
                JsonNode node = diffJsonPatch.get(i);
                if (!GenericKubernetesResourceMatcher.nodeIsChildOf(node, prefixList)) continue;
                res.add(node);
            }
            return res;
        }
        return Collections.emptyList();
    }

    @Deprecated(forRemoval=true)
    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(KubernetesDependentResource<R, P> dependentResource, R actualResource, P primary, Context<P> context, boolean considerLabelsAndAnnotations, boolean specEquality) {
        R desired = dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, specEquality, context, new String[0]);
    }

    @Deprecated(forRemoval=true)
    public static <R extends HasMetadata, P extends HasMetadata> Matcher.Result<R> match(KubernetesDependentResource<R, P> dependentResource, R actualResource, P primary, Context<P> context, boolean considerLabelsAndAnnotations, String ... ignorePaths) {
        R desired = dependentResource.desired(primary, context);
        return GenericKubernetesResourceMatcher.match(desired, actualResource, considerLabelsAndAnnotations, true, context, ignorePaths);
    }
}

