/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.javaoperatorsdk.operator.api.config.BaseConfigurationService;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceOverrider;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.DefaultResourceClassResolver;
import io.javaoperatorsdk.operator.api.config.ExecutorServiceManager;
import io.javaoperatorsdk.operator.api.config.InformerStoppedHandler;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import io.javaoperatorsdk.operator.api.config.ResourceClassResolver;
import io.javaoperatorsdk.operator.api.config.Version;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResourceFactory;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflowFactory;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ConfigurationService {
    public static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);
    public static final int DEFAULT_MAX_CONCURRENT_REQUEST = 512;
    public static final int DEFAULT_RECONCILIATION_THREADS_NUMBER = 200;
    public static final int MIN_DEFAULT_RECONCILIATION_THREADS_NUMBER = 10;
    public static final int DEFAULT_WORKFLOW_EXECUTOR_THREAD_NUMBER = 200;
    public static final int MIN_DEFAULT_WORKFLOW_EXECUTOR_THREAD_NUMBER = 10;
    public static final int DEFAULT_TERMINATION_TIMEOUT_SECONDS = 10;

    public <R extends HasMetadata> ControllerConfiguration<R> getConfigurationFor(Reconciler<R> var1);

    default public Cloner getResourceCloner() {
        return new Cloner(){

            @Override
            public <R extends HasMetadata> R clone(R object) {
                return (R)((HasMetadata)ConfigurationService.this.getKubernetesClient().getKubernetesSerialization().clone(object));
            }
        };
    }

    default public KubernetesClient getKubernetesClient() {
        return new KubernetesClientBuilder().withConfig(((ConfigBuilder)new ConfigBuilder(Config.autoConfigure(null)).withMaxConcurrentRequests(512)).build()).withKubernetesSerialization(new KubernetesSerialization()).build();
    }

    public Set<String> getKnownReconcilerNames();

    public Version getVersion();

    default public boolean checkCRDAndValidateLocalModel() {
        return false;
    }

    default public int concurrentReconciliationThreads() {
        return 200;
    }

    default public int minConcurrentReconciliationThreads() {
        return 10;
    }

    default public int concurrentWorkflowExecutorThreads() {
        return 200;
    }

    default public int minConcurrentWorkflowExecutorThreads() {
        return 10;
    }

    @Deprecated(forRemoval=true)
    default public int getTerminationTimeoutSeconds() {
        return 10;
    }

    default public Metrics getMetrics() {
        return Metrics.NOOP;
    }

    default public ExecutorService getExecutorService() {
        return ExecutorServiceManager.newThreadPoolExecutor(this.minConcurrentReconciliationThreads(), this.concurrentReconciliationThreads());
    }

    default public ExecutorService getWorkflowExecutorService() {
        return ExecutorServiceManager.newThreadPoolExecutor(this.minConcurrentWorkflowExecutorThreads(), this.concurrentWorkflowExecutorThreads());
    }

    default public boolean closeClientOnStop() {
        return true;
    }

    default public DependentResourceFactory dependentResourceFactory() {
        return DependentResourceFactory.DEFAULT;
    }

    default public Optional<LeaderElectionConfiguration> getLeaderElectionConfiguration() {
        return Optional.empty();
    }

    default public boolean stopOnInformerErrorDuringStartup() {
        return true;
    }

    default public Duration cacheSyncTimeout() {
        return Duration.ofMinutes(2L);
    }

    default public Optional<InformerStoppedHandler> getInformerStoppedHandler() {
        return Optional.of((informer, ex) -> {
            if (ex != null && informer.hasSynced()) {
                log.error("Fatal error in informer: {}. Stopping the operator", (Object)informer, (Object)ex);
                System.exit(1);
            } else {
                log.debug("Informer stopped: {}. Has synced: {}, Error: {}. This can happen as a result of stopping the controller, or due to an error on startup.See also stopOnInformerErrorDuringStartup configuration.", new Object[]{informer, informer.hasSynced(), ex});
            }
        });
    }

    default public ManagedWorkflowFactory getWorkflowFactory() {
        return ManagedWorkflowFactory.DEFAULT;
    }

    default public ResourceClassResolver getResourceClassResolver() {
        return new DefaultResourceClassResolver();
    }

    public static ConfigurationService newOverriddenConfigurationService(ConfigurationService baseConfiguration, Consumer<ConfigurationServiceOverrider> overrider) {
        if (overrider != null) {
            ConfigurationServiceOverrider toOverride = new ConfigurationServiceOverrider(baseConfiguration);
            overrider.accept(toOverride);
            return toOverride.build();
        }
        return baseConfiguration;
    }

    public static ConfigurationService newOverriddenConfigurationService(Consumer<ConfigurationServiceOverrider> overrider) {
        return ConfigurationService.newOverriddenConfigurationService(new BaseConfigurationService(), overrider);
    }

    default public ExecutorServiceManager getExecutorServiceManager() {
        return new ExecutorServiceManager(this);
    }

    default public boolean ssaBasedCreateUpdateMatchForDependentResources() {
        return true;
    }
}

