/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.apt;

import io.sundr.SundrException;
import io.sundr.codegen.api.Output;
import io.sundr.codegen.api.Renderer;
import io.sundr.model.utils.Types;
import io.sundr.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class GenericAptOutput<T>
implements Output<T> {
    private final Filer filer;
    private final Renderer<T> renderer;
    private final String moduleAndPackage;
    private final String relativePath;
    private static final StringWriter DEV_NULL = new StringWriter();

    public GenericAptOutput(Filer filer, Renderer<T> renderer, String relativePath) {
        this(filer, renderer, "", relativePath);
    }

    public GenericAptOutput(Filer filer, Renderer<T> renderer, String moduleAndPackage, String relativePath) {
        this.filer = filer;
        this.renderer = renderer;
        this.moduleAndPackage = moduleAndPackage;
        this.relativePath = relativePath;
    }

    public Function<T, Writer> getFunction() {
        return type -> {
            try {
                String rendered = this.renderer.render(type);
                Optional name = Types.parseName((String)rendered);
                if (name.isPresent()) {
                    String pkg = Types.parsePackage((String)rendered).orElse(this.moduleAndPackage);
                    String fqcn = Strings.isNullOrEmpty((String)pkg) ? (String)name.get() : pkg + "." + (String)name.get();
                    FileObject fileObject = this.filer.getResource(StandardLocation.SOURCE_OUTPUT, pkg, (String)name.get() + ".java");
                    File file = Paths.get(fileObject.toUri()).toFile();
                    return file.exists() ? DEV_NULL : this.filer.createSourceFile(fqcn, new Element[0]).openWriter();
                }
                if (Strings.isNotNullOrEmpty((String)this.relativePath)) {
                    return this.filer.createResource(StandardLocation.CLASS_OUTPUT, this.moduleAndPackage, this.relativePath, new Element[0]).openWriter();
                }
                throw new SundrException("Cannot generate resource. No output path specified and generated code does not correspond to a java class (so that output path can be inferred).");
            }
            catch (IOException e) {
                throw SundrException.launderThrowable((Throwable)e);
            }
        };
    }
}

