/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.SecondaryToPrimaryMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Mappers {
    public static final String DEFAULT_ANNOTATION_FOR_NAME = "io.javaoperatorsdk/primary-name";
    public static final String DEFAULT_ANNOTATION_FOR_NAMESPACE = "io.javaoperatorsdk/primary-namespace";

    private Mappers() {
    }

    public static <T extends HasMetadata> SecondaryToPrimaryMapper<T> fromAnnotation(String nameKey) {
        return Mappers.fromMetadata(nameKey, null, false);
    }

    public static <T extends HasMetadata> SecondaryToPrimaryMapper<T> fromAnnotation(String nameKey, String namespaceKey) {
        return Mappers.fromMetadata(nameKey, namespaceKey, false);
    }

    public static <T extends HasMetadata> SecondaryToPrimaryMapper<T> fromLabel(String nameKey) {
        return Mappers.fromMetadata(nameKey, null, true);
    }

    public static <T extends HasMetadata> SecondaryToPrimaryMapper<T> fromDefaultAnnotations() {
        return Mappers.fromMetadata(DEFAULT_ANNOTATION_FOR_NAME, DEFAULT_ANNOTATION_FOR_NAMESPACE, false);
    }

    public static <T extends HasMetadata> SecondaryToPrimaryMapper<T> fromLabel(String nameKey, String namespaceKey) {
        return Mappers.fromMetadata(nameKey, namespaceKey, true);
    }

    public static <T extends HasMetadata> SecondaryToPrimaryMapper<T> fromOwnerReference() {
        return Mappers.fromOwnerReference(false);
    }

    public static <T extends HasMetadata> SecondaryToPrimaryMapper<T> fromOwnerReference(boolean clusterScope) {
        return resource -> ResourceID.fromFirstOwnerReference(resource, clusterScope).map(Set::of).orElseGet(Collections::emptySet);
    }

    public static <T extends HasMetadata> SecondaryToPrimaryMapper<T> fromOwnerReferences(boolean clusterScope) {
        return resource -> resource.getMetadata().getOwnerReferences().stream().map(or -> ResourceID.fromOwnerReference(resource, or, clusterScope)).collect(Collectors.toSet());
    }

    private static <T extends HasMetadata> SecondaryToPrimaryMapper<T> fromMetadata(String nameKey, String namespaceKey, boolean isLabel) {
        return resource -> {
            Map map;
            ObjectMeta metadata = resource.getMetadata();
            if (metadata == null) {
                return Collections.emptySet();
            }
            Map map2 = map = isLabel ? metadata.getLabels() : metadata.getAnnotations();
            if (map == null) {
                return Collections.emptySet();
            }
            String name = (String)map.get(nameKey);
            if (name == null) {
                return Collections.emptySet();
            }
            String namespace = namespaceKey == null ? resource.getMetadata().getNamespace() : (String)map.get(namespaceKey);
            return Set.of(new ResourceID(name, namespace));
        };
    }

    public static ResourceID fromString(String cacheKey) {
        if (cacheKey == null) {
            return null;
        }
        String[] split = cacheKey.split("/");
        switch (split.length) {
            case 1: {
                return new ResourceID(split[0]);
            }
            case 2: {
                return new ResourceID(split[1], split[0]);
            }
        }
        throw new IllegalArgumentException("Cannot extract a ResourceID from " + cacheKey);
    }

    public static <OWNER extends HasMetadata, T extends HasMetadata> SecondaryToPrimaryMapper<T> fromOwnerType(Class<OWNER> clazz) {
        String kind = HasMetadata.getKind(clazz);
        return resource -> {
            ObjectMeta meta = resource.getMetadata();
            if (meta == null) {
                return Set.of();
            }
            List owners = meta.getOwnerReferences();
            if (owners == null || owners.isEmpty()) {
                return Set.of();
            }
            return owners.stream().filter(it -> kind.equals(it.getKind())).map(it -> new ResourceID(it.getName(), resource.getMetadata().getNamespace())).collect(Collectors.toSet());
        };
    }
}

