/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.Ignore;
import io.javaoperatorsdk.operator.api.reconciler.ResourceDiscriminator;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Deleter;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.api.reconciler.dependent.ReconcileResult;
import io.javaoperatorsdk.operator.processing.dependent.BulkDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.BulkDependentResourceReconciler;
import io.javaoperatorsdk.operator.processing.dependent.Creator;
import io.javaoperatorsdk.operator.processing.dependent.DependentResourceException;
import io.javaoperatorsdk.operator.processing.dependent.DependentResourceReconciler;
import io.javaoperatorsdk.operator.processing.dependent.Matcher;
import io.javaoperatorsdk.operator.processing.dependent.SingleDependentResourceReconciler;
import io.javaoperatorsdk.operator.processing.dependent.Updater;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public abstract class AbstractDependentResource<R, P extends HasMetadata>
implements DependentResource<R, P> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDependentResource.class);
    private final boolean creatable = this instanceof Creator;
    private final boolean updatable = this instanceof Updater;
    private final boolean deletable = this instanceof Deleter;
    protected Creator<R, P> creator = this.creatable ? (Creator)((Object)this) : null;
    protected Updater<R, P> updater = this.updatable ? (Updater)((Object)this) : null;
    private ResourceDiscriminator<R, P> resourceDiscriminator;
    private final DependentResourceReconciler<R, P> dependentResourceReconciler = this instanceof BulkDependentResource ? new BulkDependentResourceReconciler((BulkDependentResource)((Object)this)) : new SingleDependentResourceReconciler(this);

    protected AbstractDependentResource() {
    }

    @Override
    public ReconcileResult<R> reconcile(P primary, Context<P> context) {
        return this.dependentResourceReconciler.reconcile(primary, context);
    }

    protected ReconcileResult<R> reconcile(P primary, R actualResource, Context<P> context) {
        if (this.creatable || this.updatable) {
            if (actualResource == null) {
                if (this.creatable) {
                    R desired = this.desired(primary, context);
                    this.throwIfNull(desired, primary, "Desired");
                    this.logForOperation("Creating", primary, desired);
                    R createdResource = this.handleCreate(desired, primary, context);
                    return ReconcileResult.resourceCreated(createdResource);
                }
            } else if (this.updatable) {
                Matcher.Result<R> match = this.match(actualResource, primary, context);
                if (!match.matched()) {
                    Object desired = match.computedDesired().orElseGet(() -> this.desired(primary, context));
                    this.throwIfNull(desired, primary, "Desired");
                    this.logForOperation("Updating", primary, desired);
                    Object updatedResource = this.handleUpdate(actualResource, desired, primary, context);
                    return ReconcileResult.resourceUpdated(updatedResource);
                }
            } else {
                log.debug("Update skipped for dependent {} as it matched the existing one", actualResource);
            }
        } else {
            log.debug("Dependent {} is read-only, implement Creator and/or Updater interfaces to modify it", (Object)this.getClass().getSimpleName());
        }
        return ReconcileResult.noOperation(actualResource);
    }

    public abstract Matcher.Result<R> match(R var1, P var2, Context<P> var3);

    @Override
    public Optional<R> getSecondaryResource(P primary, Context<P> context) {
        return this.resourceDiscriminator == null ? context.getSecondaryResource(this.resourceType()) : this.resourceDiscriminator.distinguish(this.resourceType(), primary, context);
    }

    private void throwIfNull(R desired, P primary, String descriptor) {
        if (desired == null) {
            throw new DependentResourceException(descriptor + " cannot be null. Primary ID: " + ResourceID.fromResource(primary));
        }
    }

    private void logForOperation(String operation, P primary, R desired) {
        String desiredDesc = desired instanceof HasMetadata ? "'" + ((HasMetadata)desired).getMetadata().getName() + "' " + ((HasMetadata)desired).getKind() : desired.getClass().getSimpleName();
        log.debug("{} {} for primary {}", new Object[]{operation, desiredDesc, ResourceID.fromResource(primary)});
    }

    protected R handleCreate(R desired, P primary, Context<P> context) {
        R created = this.creator.create(desired, primary, context);
        this.throwIfNull(created, primary, "Created resource");
        this.onCreated(primary, created, context);
        return created;
    }

    protected abstract void onCreated(P var1, R var2, Context<P> var3);

    protected abstract void onUpdated(P var1, R var2, R var3, Context<P> var4);

    protected R handleUpdate(R actual, R desired, P primary, Context<P> context) {
        R updated = this.updater.update(actual, desired, primary, context);
        this.throwIfNull(updated, primary, "Updated resource");
        this.onUpdated(primary, updated, actual, context);
        return updated;
    }

    protected R desired(P primary, Context<P> context) {
        throw new IllegalStateException("desired method must be implemented if this DependentResource can be created and/or updated");
    }

    public void delete(P primary, Context<P> context) {
        this.dependentResourceReconciler.delete(primary, context);
    }

    protected void handleDelete(P primary, R secondary, Context<P> context) {
        throw new IllegalStateException("handleDelete method must be implemented if Deleter trait is supported");
    }

    public void setResourceDiscriminator(ResourceDiscriminator<R, P> resourceDiscriminator) {
        this.resourceDiscriminator = resourceDiscriminator;
    }

    protected boolean isCreatable() {
        return this.creatable;
    }

    protected boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public boolean isDeletable() {
        return this.deletable;
    }
}

