/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.Version;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final String CHECK_CRD_ENV_KEY = "JAVA_OPERATOR_SDK_CHECK_CRD";
    public static final String DEBUG_THREAD_POOL_ENV_KEY = "JAVA_OPERATOR_SDK_DEBUG_THREAD_POOL";
    public static final String GENERIC_PARAMETER_TYPE_ERROR_PREFIX = "Couldn't retrieve generic parameter type from ";
    public static final Version VERSION = Utils.loadFromProperties();

    @Deprecated
    public static Version loadFromProperties() {
        Date builtTime;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("version.properties");
        Properties properties = new Properties();
        if (is != null) {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                log.warn("Couldn't load version information: {}", (Object)e.getMessage());
            }
        } else {
            log.warn("Couldn't find version.properties file. Default version information will be used.");
        }
        try {
            String time = properties.getProperty("git.build.time");
            builtTime = time != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(time) : Date.from(Instant.EPOCH);
        }
        catch (Exception e) {
            log.debug("Couldn't parse git.build.time property", (Throwable)e);
            builtTime = Date.from(Instant.EPOCH);
        }
        return new Version(properties.getProperty("git.commit.id.abbrev", "unknown"), builtTime);
    }

    public static int ensureValid(int value, String description, int minValue) {
        return Utils.ensureValid(value, description, minValue, minValue);
    }

    public static int ensureValid(int value, String description, int minValue, int defaultValue) {
        if (value < minValue) {
            if (defaultValue < minValue) {
                throw new IllegalArgumentException("Default value for " + description + " must be greater than " + minValue);
            }
            log.warn("Requested " + description + " should be greater than " + minValue + ". Requested: " + value + ", using " + defaultValue + (defaultValue == minValue ? "" : " (default)") + " instead");
            value = defaultValue;
        }
        return value;
    }

    public static boolean isValidateCustomResourcesEnvVarSet() {
        return System.getProperty(CHECK_CRD_ENV_KEY) != null;
    }

    public static boolean shouldCheckCRDAndValidateLocalModel() {
        return Utils.getBooleanFromSystemPropsOrDefault(CHECK_CRD_ENV_KEY, false);
    }

    public static boolean debugThreadPool() {
        return Utils.getBooleanFromSystemPropsOrDefault(DEBUG_THREAD_POOL_ENV_KEY, false);
    }

    static boolean getBooleanFromSystemPropsOrDefault(String propertyName, boolean defaultValue) {
        String property = System.getProperty(propertyName);
        if (property == null) {
            return defaultValue;
        }
        switch (property = property.trim().toLowerCase()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        return defaultValue;
    }

    public static Class<?> getFirstTypeArgumentFromExtendedClass(Class<?> clazz) {
        try {
            Type type = clazz.getGenericSuperclass();
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new RuntimeException(GENERIC_PARAMETER_TYPE_ERROR_PREFIX + clazz.getSimpleName() + " because it doesn't extend a class that is parameterized with the type we want to retrieve", e);
        }
    }

    public static Class<?> getFirstTypeArgumentFromInterface(Class<?> clazz, Class<?> expectedImplementedInterface) {
        return Utils.getTypeArgumentFromInterfaceByIndex(clazz, expectedImplementedInterface, 0);
    }

    public static Class<?> getTypeArgumentFromInterfaceByIndex(Class<?> clazz, Class<?> expectedImplementedInterface, int index) {
        if (expectedImplementedInterface.isAssignableFrom(clazz)) {
            Type[] genericInterfaces = clazz.getGenericInterfaces();
            Optional<Class<?>> target = Utils.extractType(clazz, expectedImplementedInterface, index, genericInterfaces);
            if (target.isPresent()) {
                return target.get();
            }
            Class<?> parent = clazz.getSuperclass();
            if (!Object.class.equals(parent)) {
                return Utils.getTypeArgumentFromInterfaceByIndex(parent, expectedImplementedInterface, index);
            }
        }
        throw new IllegalArgumentException(GENERIC_PARAMETER_TYPE_ERROR_PREFIX + clazz.getSimpleName() + " because it or its superclasses don't implement " + expectedImplementedInterface.getSimpleName());
    }

    private static Optional<? extends Class<?>> extractType(Class<?> clazz, Class<?> expectedImplementedInterface, int index, Type[] genericInterfaces) {
        Optional<Object> target = Optional.empty();
        if (genericInterfaces.length > 0) {
            target = Arrays.stream(genericInterfaces).filter(type -> type.getTypeName().startsWith(expectedImplementedInterface.getName()) && type instanceof ParameterizedType).map(ParameterizedType.class::cast).findFirst().map(t -> {
                Type rawType;
                Type argument = t.getActualTypeArguments()[index];
                if (argument instanceof Class) {
                    return (Class)argument;
                }
                if (argument instanceof ParameterizedType && (rawType = ((ParameterizedType)argument).getRawType()) instanceof Class) {
                    return (Class)rawType;
                }
                throw new IllegalArgumentException(clazz.getSimpleName() + " implements " + expectedImplementedInterface.getSimpleName() + " but indirectly. Java type erasure doesn't allow to retrieve the generic type from it. Retrieved type was: " + argument);
            });
        }
        return target;
    }

    public static Class<?> getFirstTypeArgumentFromSuperClassOrInterface(Class<?> clazz, Class<?> expectedImplementedInterface) {
        try {
            Class<?> superclass = clazz.getSuperclass();
            if (!superclass.equals(Object.class)) {
                try {
                    return Utils.getFirstTypeArgumentFromExtendedClass(clazz);
                }
                catch (Exception e) {
                    try {
                        return Utils.getFirstTypeArgumentFromInterface(clazz, expectedImplementedInterface);
                    }
                    catch (Exception ex) {
                        return Utils.getFirstTypeArgumentFromSuperClassOrInterface(superclass, expectedImplementedInterface);
                    }
                }
            }
            return Utils.getFirstTypeArgumentFromInterface(clazz, expectedImplementedInterface);
        }
        catch (Exception e) {
            throw new OperatorException(GENERIC_PARAMETER_TYPE_ERROR_PREFIX + clazz.getSimpleName(), e);
        }
    }

    public static <T> T instantiateAndConfigureIfNeeded(Class<? extends T> targetClass, Class<T> expectedType, String context, Configurator<T> configurator) {
        if (expectedType.equals(targetClass)) {
            return null;
        }
        try {
            T instance = Utils.getConstructor(targetClass).newInstance(new Object[0]);
            if (configurator != null) {
                configurator.configure(instance);
            }
            return instance;
        }
        catch (IllegalAccessException | IllegalStateException | InstantiationException | InvocationTargetException e) {
            throw new OperatorException("Couldn't instantiate " + expectedType.getSimpleName() + " '" + targetClass.getName() + "'." + (String)(context != null ? " Context: " + context : ""), e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> targetClass) {
        Constructor<T> constructor;
        try {
            constructor = targetClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Couldn't find a no-arg constructor for " + targetClass.getName(), e);
        }
        constructor.setAccessible(true);
        return constructor;
    }

    public static <T> T instantiate(Class<? extends T> toInstantiate, Class<T> expectedType, String context) {
        return Utils.instantiateAndConfigureIfNeeded(toInstantiate, expectedType, context, null);
    }

    public static String contextFor(ControllerConfiguration<?> controllerConfiguration, Class<? extends DependentResource> dependentType, Class<? extends Annotation> configurationAnnotation) {
        return Utils.contextFor(controllerConfiguration.getName(), dependentType, configurationAnnotation);
    }

    public static String contextFor(String reconcilerName) {
        return Utils.contextFor(reconcilerName, null, null);
    }

    public static String contextFor(String reconcilerName, Class<? extends DependentResource> dependentType, Class<? extends Annotation> configurationAnnotation) {
        String annotationName = configurationAnnotation != null ? configurationAnnotation.getSimpleName() : io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration.class.getSimpleName();
        String context = "annotation: " + annotationName + ", ";
        if (dependentType != null) {
            context = context + "DependentResource: " + dependentType.getName() + ", ";
        }
        context = context + "reconciler: " + reconcilerName;
        return context;
    }

    @FunctionalInterface
    public static interface Configurator<T> {
        public void configure(T var1);
    }
}

